/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation;

import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class AvroParserState {
    private final Stack<AvroSchema> stack = new Stack();
    private final List<ByteBuffer> cache = new LinkedList<ByteBuffer>();
    private long size = 0L;
    private long sourceOffset;

    AvroParserState() {
        this(0L);
    }

    AvroParserState(long sourceOffset) {
        this.sourceOffset = sourceOffset;
    }

    List<ByteBuffer> getCache() {
        return this.cache;
    }

    long getSize() {
        return this.size;
    }

    void write(ByteBuffer buffer) {
        this.cache.add(buffer);
        this.size += (long)buffer.remaining();
    }

    public void pushToStack(AvroSchema schema) {
        this.stack.push(schema);
    }

    AvroSchema peekFromStack() {
        return this.stack.peek();
    }

    boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    void popOffStack() {
        this.stack.pop();
    }

    public boolean sizeGreaterThan(long sizeRequired) {
        return this.size >= sizeRequired;
    }

    public long getSourceOffset() {
        return this.sourceOffset;
    }

    public List<ByteBuffer> read(long size) {
        LinkedList<ByteBuffer> result = new LinkedList<ByteBuffer>();
        Iterator<ByteBuffer> bufferIterator = this.cache.iterator();
        long needed = size;
        while (needed > 0L) {
            ByteBuffer current = bufferIterator.next();
            if ((long)current.remaining() <= needed) {
                result.add(current);
                bufferIterator.remove();
                needed -= (long)current.remaining();
                this.size -= (long)current.remaining();
                this.sourceOffset += (long)current.remaining();
                continue;
            }
            ByteBuffer dup = current.duplicate();
            this.size -= (long)((int)needed);
            this.sourceOffset += (long)((int)needed);
            dup.limit(dup.position() + (int)needed);
            current.position(dup.position() + (int)needed);
            needed = 0L;
            result.add(dup);
        }
        return result;
    }

    public byte read() {
        Iterator<ByteBuffer> iterator = this.cache.iterator();
        ByteBuffer buffer = iterator.next();
        byte b = buffer.get();
        if (buffer.remaining() == 0) {
            iterator.remove();
        }
        --this.size;
        ++this.sourceOffset;
        return b;
    }
}

