/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphRelationship;

@SearchableAnalyserPlugin(id="GraphModelSearchableAnalyser", name="Search in Neo4j Graph Model metadata")
public class GraphModelSearchableAnalyser
extends BaseMetadataSearchableAnalyser<GraphModel>
implements ISearchableAnalyser<GraphModel> {
    public Class<GraphModel> getSearchableClass() {
        return GraphModel.class;
    }

    public List<ISearchResult> search(ISearchable<GraphModel> searchable, ISearchQuery searchQuery) {
        GraphModel graphModel = (GraphModel)((Object)searchable.getSearchableObject());
        String component = this.getMetadataComponent();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "Name", graphModel.getName(), component);
        this.matchProperty(searchable, results, searchQuery, "Description", graphModel.getDescription(), component);
        for (GraphNode graphNode : graphModel.getNodes()) {
            this.matchProperty(searchable, results, searchQuery, "Node name", graphNode.getName(), component);
            this.matchProperty(searchable, results, searchQuery, "Node description", graphNode.getDescription(), component);
            for (String nodeLabel : graphNode.getLabels()) {
                this.matchProperty(searchable, results, searchQuery, "Node label", nodeLabel, component);
            }
            for (GraphProperty property : graphNode.getProperties()) {
                this.matchProperty(searchable, results, searchQuery, "Node property name", property.getName(), component);
                this.matchProperty(searchable, results, searchQuery, "Node property type", property.getType().name(), component);
                this.matchProperty(searchable, results, searchQuery, "Node property description", property.getDescription(), component);
            }
        }
        for (GraphRelationship relationship : graphModel.getRelationships()) {
            this.matchProperty(searchable, results, searchQuery, "Relationship name", relationship.getName(), component);
            this.matchProperty(searchable, results, searchQuery, "Relationship description", relationship.getDescription(), component);
            this.matchProperty(searchable, results, searchQuery, "Relationship source node", relationship.getNodeSource(), component);
            this.matchProperty(searchable, results, searchQuery, "Relationship target node", relationship.getNodeTarget(), component);
        }
        return results;
    }
}

