/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.compute;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.processors.platform.client.ClientCloseableResource;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientNotification;
import org.apache.ignite.internal.processors.platform.client.ClientObjectNotification;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.task.GridTaskProcessor;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;

class ClientComputeTask
implements ClientCloseableResource {
    private static final byte NO_FAILOVER_FLAG_MASK = 1;
    private static final byte NO_RESULT_CACHE_FLAG_MASK = 2;
    public static final byte KEEP_BINARY_FLAG_MASK = 4;
    private final ClientConnectionContext ctx;
    private final IgniteLogger log;
    private volatile long taskId;
    private volatile ComputeTaskInternalFuture<Object> taskFut;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final boolean systemTask;

    ClientComputeTask(ClientConnectionContext ctx, boolean sysTask) {
        assert (ctx != null);
        this.ctx = ctx;
        this.systemTask = sysTask;
        this.log = ctx.kernalContext().log(this.getClass());
    }

    void execute(long taskId, String taskName, Object arg, Set<UUID> nodeIds, byte flags, long timeout) {
        assert (taskName != null);
        this.taskId = taskId;
        GridTaskProcessor task = this.ctx.kernalContext().task();
        IgnitePredicate<ClusterNode> nodePredicate = F.isEmpty(nodeIds) ? node -> !node.isClient() : F.nodeForNodeIds(nodeIds);
        TaskExecutionOptions opts = TaskExecutionOptions.options().asPublicRequest().withProjectionPredicate(nodePredicate).withTimeout(timeout);
        if ((flags & 1) != 0) {
            opts.withFailoverDisabled();
        }
        if ((flags & 2) != 0) {
            opts.withResultCacheDisabled();
        }
        this.taskFut = task.execute(taskName, arg, opts);
        if (this.taskFut.isDone() && this.taskFut.error() != null) {
            if (this.ctx.kernalContext().clientListener().sendServerExceptionStackTraceToClient()) {
                throw new IgniteClientException(1, this.taskFut.error().getMessage(), this.taskFut.error());
            }
            throw new IgniteClientException(1, this.taskFut.error().getMessage());
        }
    }

    void onResponseSent() {
        this.taskFut.listen(() -> {
            try {
                ClientNotification notification;
                if (this.taskFut.error() != null) {
                    String msg = this.ctx.kernalContext().clientListener().sendServerExceptionStackTraceToClient() ? this.taskFut.error().getMessage() + U.nl() + X.getFullStackTrace(this.taskFut.error()) : this.taskFut.error().getMessage();
                    notification = new ClientNotification(6001, this.taskId, msg);
                } else {
                    notification = this.taskFut.isCancelled() ? new ClientNotification(6001, this.taskId, "Task was cancelled") : new ClientObjectNotification(6001, this.taskId, this.taskFut.result());
                }
                this.ctx.notifyClient(notification);
            }
            finally {
                if (this.closed.compareAndSet(false, true)) {
                    if (!this.systemTask) {
                        this.ctx.decrementActiveTasksCount();
                    }
                    this.ctx.resources().release(this.taskId);
                }
            }
        });
    }

    long taskId() {
        return this.taskId;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (!this.systemTask) {
                this.ctx.decrementActiveTasksCount();
            }
            try {
                if (this.taskFut != null) {
                    this.taskFut.cancel();
                }
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Failed to cancel task", e);
            }
        }
    }
}

