/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.datastructures;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongImpl;
import org.apache.ignite.internal.processors.platform.client.ClientBooleanResponse;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.datastructures.ClientAtomicLongRequest;

public class ClientAtomicLongValueCompareAndSetRequest
extends ClientAtomicLongRequest {
    private final long expected;
    private final long val;

    public ClientAtomicLongValueCompareAndSetRequest(BinaryRawReader reader) {
        super(reader);
        this.expected = reader.readLong();
        this.val = reader.readLong();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        GridCacheAtomicLongImpl atomicLong = this.atomicLong(ctx);
        if (atomicLong == null) {
            return this.notFoundResponse();
        }
        return new ClientBooleanResponse(this.requestId(), atomicLong.compareAndSet(this.expected, this.val));
    }
}

