/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.examples.echo;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriverAdapter;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.examples.echo.EchoBenchmarkArguments;

public class EchoBenchmark
extends BenchmarkDriverAdapter {
    private final AtomicInteger cntr = new AtomicInteger();
    private final ConcurrentMap<Thread, Socket> sockMap = new ConcurrentHashMap<Thread, Socket>();
    private final EchoBenchmarkArguments args = new EchoBenchmarkArguments();

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.println("Started benchmark with id: " + cfg.memberId());
        BenchmarkUtils.jcommander(cfg.commandLineArguments(), this.args, "<echo-driver>");
        EchoBenchmark.createSocket(this.args);
    }

    @Override
    public void tearDown() throws Exception {
        for (Socket sock : this.sockMap.values()) {
            sock.close();
        }
    }

    @Override
    public boolean test(Map<Object, Object> ctx) throws Exception {
        int b;
        Socket sock = this.socket(this.args);
        String req = "ping-" + this.cntr.incrementAndGet();
        byte[] reqBytes = req.getBytes();
        sock.getOutputStream().write(reqBytes);
        byte[] resBytes = new byte[reqBytes.length];
        InputStream in = sock.getInputStream();
        for (int read = 0; read < resBytes.length && (b = in.read(resBytes, read, resBytes.length - read)) >= 0; read += b) {
        }
        String res = new String(resBytes);
        if (!req.equals(res)) {
            throw new Exception("Invalid echo response [req=" + req + ", res=" + res + ']');
        }
        return true;
    }

    @Override
    public String description() {
        String desc = BenchmarkUtils.description(this.cfg, this);
        return desc.isEmpty() ? this.getClass().getSimpleName() + this.args.description() + this.cfg.defaultDescription() : desc;
    }

    @Override
    public String usage() {
        return BenchmarkUtils.usage(this.args);
    }

    private Socket socket(EchoBenchmarkArguments args) throws Exception {
        Socket sock = (Socket)this.sockMap.get(Thread.currentThread());
        if (sock == null) {
            sock = EchoBenchmark.createSocket(args);
            Socket old = this.sockMap.putIfAbsent(Thread.currentThread(), sock);
            if (old != null) {
                sock = old;
            }
        }
        return sock;
    }

    private static Socket createSocket(EchoBenchmarkArguments args) throws Exception {
        try {
            return new Socket(args.localBind(), args.port());
        }
        catch (IOException e) {
            throw new Exception("Can not connect to EchoServer, is server running?", e);
        }
    }
}

