/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.store.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.store.jdbc.CacheAbstractJdbcStore;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;

public abstract class IgniteJdbcStoreAbstractBenchmark
extends IgniteAbstractBenchmark {
    protected IgniteCache<Object, Object> cache;

    protected abstract IgniteCache<Object, Object> cache();

    protected abstract int fillRange();

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.cache = this.cache();
        CacheConfiguration cc = (CacheConfiguration)this.cache.getConfiguration(CacheConfiguration.class);
        CacheAbstractJdbcStore store = (CacheAbstractJdbcStore)cc.getCacheStoreFactory().create();
        try (Connection conn = store.getDataSource().getConnection();){
            int i;
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            try {
                stmt.executeUpdate("delete from SAMPLE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.executeUpdate("CREATE TABLE SAMPLE (id integer not null, value integer, PRIMARY KEY(id))");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            conn.commit();
            U.closeQuiet((AutoCloseable)stmt);
            PreparedStatement orgStmt = conn.prepareStatement("INSERT INTO SAMPLE(id, value) VALUES (?, ?)");
            for (i = 1; i <= this.fillRange(); ++i) {
                orgStmt.setInt(1, i);
                orgStmt.setInt(2, i);
                orgStmt.addBatch();
                if (i % 1000 != 0) continue;
                orgStmt.executeBatch();
            }
            if (i % 1000 != 0) {
                orgStmt.executeBatch();
            }
            conn.commit();
            U.closeQuiet((AutoCloseable)stmt);
        }
    }

    @Override
    public void tearDown() throws Exception {
        CacheConfiguration cc = (CacheConfiguration)this.cache.getConfiguration(CacheConfiguration.class);
        CacheAbstractJdbcStore store = (CacheAbstractJdbcStore)cc.getCacheStoreFactory().create();
        try (Connection conn = store.getDataSource().getConnection();){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            try {
                stmt.executeUpdate("delete from SAMPLE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            U.closeQuiet((AutoCloseable)stmt);
        }
        super.tearDown();
    }
}

