/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateTableOption;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteResource;
import org.jetbrains.annotations.NotNull;

public abstract class IgniteSqlOption<E extends Enum<E>>
extends SqlCall {
    protected final SqlLiteral key;
    protected final SqlNode value;
    private final Class<E> enumCls;

    protected IgniteSqlOption(SqlLiteral key, SqlNode value, SqlParserPos pos, Class<E> enumCls) {
        super(pos);
        this.enumCls = enumCls;
        this.key = key;
        this.value = value;
    }

    @NotNull
    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.key, (Object)this.value);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new IgniteSqlCreateTableOption(this.key, this.value, pos);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.key.unparse(writer, leftPrec, rightPrec);
        writer.keyword("=");
        this.value.unparse(writer, leftPrec, rightPrec);
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        throw new UnsupportedOperationException();
    }

    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (node == this) {
            return true;
        }
        if (!(node instanceof IgniteSqlOption)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        IgniteSqlOption that = (IgniteSqlOption)node;
        if (!this.getOperator().getName().equalsIgnoreCase(that.getOperator().getName())) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        if (this.key != that.key) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        return this.value.equalsDeep(that.value, litmus);
    }

    public E key() {
        return (E)((Enum)this.key.getValueAs(this.enumCls));
    }

    public SqlNode value() {
        return this.value;
    }

    protected static <T extends IgniteSqlOption<E>, E extends Enum<E>> SqlNodeList parseOptionList(String opts, SqlParserPos pos, OptionFactory<T> factory, Class<E> enumCls) {
        String[] pairs;
        SqlNodeList list = new SqlNodeList(pos);
        for (String pair : pairs = opts.split(",")) {
            String[] keyVal = pair.split("=");
            if (keyVal.length != 2) {
                throw SqlUtil.newContextException((SqlParserPos)pos, IgniteResource.INSTANCE.cannotParsePair(pair));
            }
            String key = keyVal[0].trim();
            String val = keyVal[1].trim();
            E optionKey = Enum.valueOf(enumCls, key.toUpperCase());
            if (optionKey == null) {
                throw SqlUtil.newContextException((SqlParserPos)pos, IgniteResource.INSTANCE.illegalOption(key));
            }
            list.add((SqlNode)factory.create(SqlLiteral.createSymbol(optionKey, (SqlParserPos)pos), (SqlNode)new SqlIdentifier(val, pos), pos));
        }
        return list;
    }

    protected static interface OptionFactory<T> {
        public T create(SqlLiteral var1, SqlNode var2, SqlParserPos var3);
    }
}

