/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedBooleanProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.processors.query.DistributedSqlConfiguration;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class DistributedIndexingConfiguration
extends DistributedSqlConfiguration {
    public static final HashSet<String> DFLT_DISABLED_FUNCS = (HashSet)Arrays.stream(new String[]{"FILE_READ", "FILE_WRITE", "CSVWRITE", "CSVREAD", "MEMORY_FREE", "MEMORY_USED", "LOCK_MODE", "LINK_SCHEMA", "SESSION_ID", "CANCEL_SESSION"}).collect(Collectors.toSet());
    private final SimpleDistributedProperty<HashSet<String>> disabledSqlFuncs = new SimpleDistributedProperty("sql.disabledFunctions", SimpleDistributedProperty::parseStringSet, "List of disabled SQL functions. Specify comma-separated functions to set a value.");
    private final DistributedBooleanProperty disableCreateLuceneIndexForStringValueType = DistributedBooleanProperty.detachedBooleanProperty((String)"sql.disableCreateLuceneIndexForStringValueType", (String)"Flag to disable creation Lucene index for String value type by default.");

    public DistributedIndexingConfiguration(GridKernalContext ctx, final IgniteLogger log) {
        super(ctx, log);
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedIndexingConfiguration.this.disabledSqlFuncs.addListener(DistributedConfigurationUtils.makeUpdateListener((String)"SQL parameter '%s' was changed from '%s' to '%s'", (IgniteLogger)log));
                dispatcher.registerProperty(DistributedIndexingConfiguration.this.disabledSqlFuncs);
                dispatcher.registerProperty((DistributedChangeableProperty)DistributedIndexingConfiguration.this.disableCreateLuceneIndexForStringValueType);
            }

            public void onReadyToWrite() {
                DistributedConfigurationUtils.setDefaultValue(DistributedIndexingConfiguration.this.disabledSqlFuncs, DFLT_DISABLED_FUNCS, (IgniteLogger)log);
                DistributedConfigurationUtils.setDefaultValue((DistributedProperty)DistributedIndexingConfiguration.this.disableCreateLuceneIndexForStringValueType, (Serializable)Boolean.valueOf(false), (IgniteLogger)log);
            }
        });
    }

    public Set<String> disabledFunctions() {
        HashSet<String> ret = (HashSet<String>)this.disabledSqlFuncs.get();
        return ret != null ? ret : DFLT_DISABLED_FUNCS;
    }

    public GridFutureAdapter<?> disabledFunctions(HashSet<String> disabledFuncs) throws IgniteCheckedException {
        return this.disabledSqlFuncs.propagateAsync(disabledFuncs);
    }

    public void listenDisabledFunctions(DistributePropertyListener<HashSet<String>> lsnr) {
        this.disabledSqlFuncs.addListener(lsnr);
    }

    public boolean isDisableCreateLuceneIndexForStringValueType() {
        Boolean ret = (Boolean)this.disableCreateLuceneIndexForStringValueType.get();
        return ret != null && ret != false;
    }

    public GridFutureAdapter<?> disableCreateLuceneIndexForStringValueType(boolean disableCreateIdx) throws IgniteCheckedException {
        return this.disableCreateLuceneIndexForStringValueType.propagateAsync((Serializable)Boolean.valueOf(disableCreateIdx));
    }
}

