/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AggregateNode;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.lang.RunnableX;
import org.apache.ignite.internal.util.typedef.F;

public class SortAggregateNode<Row>
extends AggregateNode<Row> {
    private final ImmutableBitSet grpSet;
    private final Comparator<Row> comp;
    private final Deque<Row> outBuf = new ArrayDeque<Row>(IN_BUFFER_SIZE);
    private Row prevRow;
    private Group grp;
    private int requested;
    private int waiting;
    private int cmpRes;

    public SortAggregateNode(ExecutionContext<Row> ctx, RelDataType rowType, AggregateType type, ImmutableBitSet grpSet, Supplier<List<AccumulatorWrapper<Row>>> accFactory, RowHandler.RowFactory<Row> rowFactory, Comparator<Row> comp) {
        super(ctx, rowType, type, accFactory, rowFactory, ARRAY_ROW_OVERHEAD);
        assert (Objects.nonNull(comp));
        this.grpSet = grpSet;
        this.comp = comp;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.outBuf.isEmpty()) {
            this.doPush();
        }
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(IN_BUFFER_SIZE);
        } else if (this.waiting < 0) {
            this.downstream().end();
        }
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        if (this.grp != null) {
            int cmp = this.comp.compare(row, this.prevRow);
            if (cmp == 0) {
                this.grp.add(row);
                if (this.hasAggAccum) {
                    this.nodeMemoryTracker.onRowAdded(row);
                }
            } else {
                if (this.cmpRes == 0) {
                    this.cmpRes = cmp;
                } else assert (Integer.signum(cmp) == Integer.signum(this.cmpRes)) : "Input not sorted";
                this.outBuf.add(this.grp.row());
                this.grp = this.newGroup(row);
                this.doPush();
            }
        } else {
            this.grp = this.newGroup(row);
        }
        this.prevRow = row;
        if (this.waiting == 0 && this.requested > 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.context().execute((RunnableX & Serializable)() -> this.source().request(IN_BUFFER_SIZE), this::onError);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        if (this.grp != null) {
            this.outBuf.add(this.grp.row());
            this.doPush();
        }
        if (this.requested > 0) {
            this.downstream().end();
        }
        this.grp = null;
        this.prevRow = null;
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.grp = null;
        this.prevRow = null;
        this.nodeMemoryTracker.reset();
    }

    private Group newGroup(Row r) {
        Object[] grpKeys = new Object[this.grpSet.cardinality()];
        List fldIdxs = this.grpSet.asList();
        RowHandler<Row> rowHnd = this.rowFactory.handler();
        for (int i = 0; i < grpKeys.length; ++i) {
            grpKeys[i] = rowHnd.get((Integer)fldIdxs.get(i), r);
        }
        Group grp = new Group(grpKeys);
        grp.add(r);
        if (this.hasAggAccum) {
            this.nodeMemoryTracker.reset();
            this.nodeMemoryTracker.onRowAdded(r);
        }
        return grp;
    }

    private void doPush() throws Exception {
        while (this.requested > 0 && !this.outBuf.isEmpty()) {
            --this.requested;
            this.downstream().push(this.outBuf.poll());
        }
    }

    private class Group {
        private final List<AccumulatorWrapper<Row>> accumWrps;
        private final Object[] grpKeys;

        private Group(Object[] grpKeys) {
            this.grpKeys = grpKeys;
            this.accumWrps = SortAggregateNode.this.hasAccumulators() ? (List)SortAggregateNode.this.accFactory.get() : Collections.emptyList();
        }

        private void add(Row row) {
            if (SortAggregateNode.this.type == AggregateType.REDUCE) {
                this.addOnReducer(row);
            } else {
                this.addOnMapper(row);
            }
        }

        private Row row() {
            if (SortAggregateNode.this.type == AggregateType.MAP) {
                return this.rowOnMapper();
            }
            return this.rowOnReducer();
        }

        private void addOnMapper(Row row) {
            for (AccumulatorWrapper wrapper : this.accumWrps) {
                wrapper.add(row);
            }
        }

        private void addOnReducer(Row row) {
            RowHandler hnd = SortAggregateNode.this.context().rowHandler();
            List accums = SortAggregateNode.this.hasAccumulators() ? (List)hnd.get(hnd.columnCount(row) - 1, row) : Collections.emptyList();
            for (int i = 0; i < accums.size(); ++i) {
                AccumulatorWrapper wrapper = this.accumWrps.get(i);
                Accumulator accum = (Accumulator)accums.get(i);
                wrapper.apply(accum);
            }
        }

        private Row rowOnMapper() {
            Object[] fields = new Object[SortAggregateNode.this.grpSet.cardinality() + (SortAggregateNode.this.accFactory != null ? 1 : 0)];
            int i = 0;
            for (Object grpKey : this.grpKeys) {
                fields[i++] = grpKey;
            }
            if (SortAggregateNode.this.hasAccumulators()) {
                fields[i] = Commons.transform(this.accumWrps, AccumulatorWrapper::accumulator);
            }
            return SortAggregateNode.this.rowFactory.create(fields);
        }

        private Row rowOnReducer() {
            Object[] fields = new Object[SortAggregateNode.this.grpSet.cardinality() + this.accumWrps.size()];
            int i = 0;
            for (Object grpKey : this.grpKeys) {
                fields[i++] = grpKey;
            }
            for (AccumulatorWrapper accumulatorWrapper : this.accumWrps) {
                fields[i++] = accumulatorWrapper.end();
            }
            return SortAggregateNode.this.rowFactory.create(fields);
        }
    }
}

