/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.CalciteQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadata;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.typedef.F;

public class FieldsMetadataImpl
implements FieldsMetadata {
    private final RelDataType rowType;
    private final RelDataType sqlRowType;
    private final List<List<String>> origins;
    private final List<String> aliases;

    public FieldsMetadataImpl(RelDataType rowType, List<List<String>> origins, List<String> aliases) {
        this(rowType, rowType, origins, aliases);
    }

    public FieldsMetadataImpl(RelDataType sqlRowType, RelDataType rowType, List<List<String>> origins, List<String> aliases) {
        this.rowType = rowType;
        this.sqlRowType = sqlRowType;
        this.origins = origins;
        this.aliases = aliases;
    }

    @Override
    public RelDataType rowType() {
        return this.rowType;
    }

    @Override
    public List<GridQueryFieldMetadata> queryFieldsMetadata(IgniteTypeFactory typeFactory) {
        List fields = this.sqlRowType.getFieldList();
        assert (F.isEmpty(this.origins) || fields.size() == this.origins.size());
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < fields.size(); ++i) {
            List<String> origin = !F.isEmpty(this.origins) ? this.origins.get(i) : null;
            String alias = this.aliases != null && this.aliases.size() > i ? this.aliases.get(i) : null;
            RelDataTypeField field = (RelDataTypeField)fields.get(i);
            RelDataType fieldType = field.getType();
            Type fieldCls = typeFactory.getResultClass(fieldType);
            b.add((Object)new CalciteQueryFieldMetadata(F.isEmpty(origin) ? null : origin.get(0), F.isEmpty(origin) ? null : origin.get(1), alias != null ? alias : (F.isEmpty(origin) ? field.getName() : origin.get(2)), fieldCls == null ? Void.class.getName() : fieldCls.getTypeName(), fieldType.getPrecision(), fieldType.getScale(), fieldType.isNullable()));
        }
        return b.build();
    }
}

