/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker;

import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.DumpSupported;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.InvalidContext;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.MemoryCalculator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageMetaInfoStore;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.IgniteUtils;

public abstract class PageLockTracker<T extends PageLockDump>
implements PageLockListener,
DumpSupported<T> {
    private static final long OVERHEAD_SIZE = 76L;
    public static final int OP_OFFSET = 16;
    public static final int LOCK_IDX_MASK = -65536;
    public static final int LOCK_OP_MASK = 255;
    public static final int READ_LOCK = 1;
    public static final int READ_UNLOCK = 2;
    public static final int WRITE_LOCK = 3;
    public static final int WRITE_UNLOCK = 4;
    public static final int BEFORE_READ_LOCK = 5;
    public static final int BEFORE_WRITE_LOCK = 6;
    protected final String name;
    protected final PageMetaInfoStore pages;
    protected int heldLockCnt;
    protected int nextOp;
    protected int nextOpStructureId;
    protected long nextOpPageId;
    private long opCntr;
    private volatile boolean dump;
    private volatile boolean locked;
    private volatile InvalidContext<T> invalidCtx;

    protected PageLockTracker(String name, PageMetaInfoStore pages, MemoryCalculator memCalc) {
        this.name = name;
        this.pages = pages;
        memCalc.onHeapAllocated(76L);
    }

    public void onBeforeWriteLock0(int structureId, long pageId, long page) {
        this.nextOp = 6;
        this.nextOpStructureId = structureId;
        this.nextOpPageId = pageId;
    }

    public void onBeforeReadLock0(int structureId, long pageId, long page) {
        this.nextOp = 5;
        this.nextOpStructureId = structureId;
        this.nextOpPageId = pageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeWriteLock(int structureId, long pageId, long page) {
        if (this.isInvalid()) {
            return;
        }
        this.lock();
        try {
            this.onBeforeWriteLock0(structureId, pageId, page);
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWriteLock(int structureId, long pageId, long page, long pageAddr) {
        if (this.checkFailedLock(pageAddr) || this.isInvalid()) {
            return;
        }
        this.lock();
        try {
            this.onWriteLock0(structureId, pageId, page, pageAddr);
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWriteUnlock(int structureId, long pageId, long page, long pageAddr) {
        if (this.isInvalid()) {
            return;
        }
        this.lock();
        try {
            this.onWriteUnlock0(structureId, pageId, page, pageAddr);
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeReadLock(int structureId, long pageId, long page) {
        if (this.isInvalid()) {
            return;
        }
        this.lock();
        try {
            this.onBeforeReadLock0(structureId, pageId, page);
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadLock(int structureId, long pageId, long page, long pageAddr) {
        if (this.checkFailedLock(pageAddr) || this.isInvalid()) {
            return;
        }
        this.lock();
        try {
            this.onReadLock0(structureId, pageId, page, pageAddr);
        }
        finally {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadUnlock(int structureId, long pageId, long page, long pageAddr) {
        if (this.isInvalid()) {
            return;
        }
        this.lock();
        try {
            this.onReadUnlock0(structureId, pageId, page, pageAddr);
        }
        finally {
            this.unLock();
        }
    }

    public abstract void onWriteLock0(int var1, long var2, long var4, long var6);

    public abstract void onWriteUnlock0(int var1, long var2, long var4, long var6);

    public abstract void onReadLock0(int var1, long var2, long var4, long var6);

    public abstract void onReadUnlock0(int var1, long var2, long var4, long var6);

    public boolean isInvalid() {
        return this.invalidCtx != null;
    }

    private boolean checkFailedLock(long pageAddr) {
        if (pageAddr == 0L) {
            this.nextOp = 0;
            this.nextOpStructureId = 0;
            this.nextOpPageId = 0L;
            return true;
        }
        return false;
    }

    public InvalidContext<T> invalidContext() {
        return this.invalidCtx;
    }

    @Override
    public void close() {
        this.pages.free();
    }

    protected void invalid(String msg) {
        T dump = this.snapshot();
        this.invalidCtx = new InvalidContext<T>(msg, dump);
    }

    private void lock() {
        while (!this.lock0()) {
        }
    }

    private boolean lock0() {
        this.awaitDump();
        this.locked = true;
        if (this.dump) {
            this.locked = false;
            return false;
        }
        return true;
    }

    private void unLock() {
        ++this.opCntr;
        this.locked = false;
    }

    private void awaitDump() {
        while (this.dump) {
        }
    }

    private void awaitLocks() {
        while (this.locked) {
        }
    }

    public long operationsCounter() {
        boolean locked = this.locked;
        return this.opCntr;
    }

    public int heldLocksNumber() {
        boolean locked = this.locked;
        return this.heldLockCnt;
    }

    protected boolean validateOperation(int structureId, long pageId, int op) {
        if (this.nextOpStructureId == 0 || this.nextOp == 0 || this.nextOpPageId == 0L) {
            return true;
        }
        if (op == 1 && this.nextOp != 5 || op == 3 && this.nextOp != 6 || structureId != this.nextOpStructureId || pageId != this.nextOpPageId) {
            this.invalid("Unepected operation: exp=" + PageLockTracker.argsToString(this.nextOpStructureId, this.nextOpPageId, this.nextOp) + ",actl=" + PageLockTracker.argsToString(structureId, pageId, op));
            return false;
        }
        return true;
    }

    protected abstract T snapshot();

    @Override
    public synchronized boolean acquireSafePoint() {
        return this.dump ? false : (this.dump = true);
    }

    @Override
    public synchronized boolean releaseSafePoint() {
        boolean bl;
        if (!this.dump) {
            bl = false;
        } else {
            this.dump = false;
            bl = !false;
        }
        return bl;
    }

    @Override
    public synchronized T dump() {
        boolean needRelease = this.acquireSafePoint();
        this.awaitLocks();
        T dump0 = this.snapshot();
        if (needRelease) {
            this.releaseSafePoint();
        }
        return dump0;
    }

    public static String argsToString(int structureId, long pageId, int flags) {
        return "[structureId=" + structureId + ", pageId" + PageLockTracker.pageIdToString(pageId) + "]";
    }

    public static String pageIdToString(long pageId) {
        return "pageId=" + pageId + " [pageIdHex=" + IgniteUtils.hexLong(pageId) + ", partId=" + PageIdUtils.partId(pageId) + ", pageIdx=" + PageIdUtils.pageIndex(pageId) + ", flags=" + IgniteUtils.hexInt(PageIdUtils.flag(pageId)) + "]";
    }
}

