/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.processors.platform.client.ClientCloseableResource;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;

public class ClientResourceRegistry {
    private final Map<Long, Object> res = new ConcurrentHashMap<Long, Object>();
    private final AtomicLong idGen = new AtomicLong();

    public long put(Object obj) {
        long id = this.idGen.incrementAndGet();
        this.res.put(id, obj);
        return id;
    }

    public <T> T get(long hnd) {
        Object obj = this.res.get(hnd);
        if (obj == null) {
            throw new IgniteClientException(1011, "Failed to find resource with id: " + hnd);
        }
        return (T)obj;
    }

    public void release(long hnd) {
        Object obj = this.res.remove(hnd);
        if (obj == null) {
            throw new IgniteClientException(1011, "Failed to find resource with id: " + hnd);
        }
        ClientResourceRegistry.closeIfNeeded(obj);
    }

    public void clean() {
        for (Map.Entry<Long, Object> e : this.res.entrySet()) {
            ClientResourceRegistry.closeIfNeeded(e.getValue());
        }
    }

    private static void closeIfNeeded(Object res) {
        if (res instanceof ClientCloseableResource) {
            ((ClientCloseableResource)res).close();
        }
    }
}

