/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.cli.sql.MetadataSupplier;
import org.apache.ignite.internal.cli.sql.SqlSchema;

public class SqlSchemaLoader {
    private final MetadataSupplier metadataSupplier;

    public SqlSchemaLoader(MetadataSupplier metadataSupplier) {
        this.metadataSupplier = metadataSupplier;
    }

    public SqlSchema loadSchema() {
        HashMap<String, Map<String, Set<String>>> schema = new HashMap<String, Map<String, Set<String>>>();
        try (ResultSet rs = this.metadataSupplier.getMetaData().getTables(null, null, null, null);){
            while (rs.next()) {
                String tableSchema = rs.getString("TABLE_SCHEM");
                Map tables = schema.computeIfAbsent(tableSchema, schemaName -> new HashMap());
                String tableName = rs.getString("TABLE_NAME");
                tables.put(tableName, this.loadColumns(tableSchema, tableName));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new SqlSchema(schema);
    }

    private Set<String> loadColumns(String schemaName, String tableName) {
        HashSet<String> columns = new HashSet<String>();
        try (ResultSet rs = this.metadataSupplier.getMetaData().getColumns(null, schemaName, tableName, null);){
            while (rs.next()) {
                columns.add(rs.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return columns;
    }
}

