/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.sql.ClientResultSetMetadata;
import org.apache.ignite.internal.client.sql.ClientSqlRow;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.CursorClosedException;
import org.apache.ignite.sql.NoRowSetExpectedException;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlException;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

class ClientAsyncResultSet
implements AsyncResultSet {
    private final ClientChannel ch;
    private final Long resourceId;
    private final boolean hasRowSet;
    private final boolean wasApplied;
    private final long affectedRows;
    private final ResultSetMetadata metadata;
    private volatile List<SqlRow> rows;
    private volatile boolean hasMorePages;
    private volatile boolean closed;

    public ClientAsyncResultSet(ClientChannel ch, ClientMessageUnpacker in) {
        this.ch = ch;
        this.resourceId = in.tryUnpackNil() ? null : Long.valueOf(in.unpackLong());
        this.hasRowSet = in.unpackBoolean();
        this.hasMorePages = in.unpackBoolean();
        this.wasApplied = in.unpackBoolean();
        this.affectedRows = in.unpackLong();
        ClientResultSetMetadata clientResultSetMetadata = this.metadata = this.hasRowSet ? new ClientResultSetMetadata(in) : null;
        if (this.hasRowSet) {
            this.readRows(in);
        }
    }

    @Nullable
    public ResultSetMetadata metadata() {
        return this.metadata;
    }

    public boolean hasRowSet() {
        return this.hasRowSet;
    }

    public long affectedRows() {
        return this.affectedRows;
    }

    public boolean wasApplied() {
        return this.wasApplied;
    }

    public Iterable<SqlRow> currentPage() {
        this.requireResultSet();
        return this.rows;
    }

    public int currentPageSize() {
        this.requireResultSet();
        return this.rows.size();
    }

    public CompletableFuture<? extends AsyncResultSet> fetchNextPage() {
        this.requireResultSet();
        if (this.closed) {
            return CompletableFuture.failedFuture((Throwable)new CursorClosedException());
        }
        if (!this.hasMorePages()) {
            return CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.CURSOR_NO_MORE_PAGES_ERR, "There are no more pages."));
        }
        return this.ch.serviceAsync(51, w -> w.out().packLong(this.resourceId.longValue()), r -> {
            this.readRows(r.in());
            this.hasMorePages = r.in().unpackBoolean();
            if (!this.hasMorePages) {
                this.closed = true;
            }
            return this;
        });
    }

    public boolean hasMorePages() {
        return this.resourceId != null && this.hasMorePages;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.resourceId == null || this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        this.closed = true;
        return this.ch.serviceAsync(52, w -> w.out().packLong(this.resourceId.longValue()), null);
    }

    private void requireResultSet() {
        if (!this.hasRowSet()) {
            throw new NoRowSetExpectedException();
        }
    }

    private void readRows(ClientMessageUnpacker in) {
        int size = in.unpackArrayHeader();
        int rowSize = this.metadata.columns().size();
        ArrayList<ClientSqlRow> res = new ArrayList<ClientSqlRow>(size);
        for (int i = 0; i < size; ++i) {
            ArrayList<Object> row = new ArrayList<Object>(rowSize);
            BinaryTupleReader tupleReader = new BinaryTupleReader(rowSize, in.readBinaryUnsafe());
            for (int j = 0; j < rowSize; ++j) {
                ColumnMetadata col = (ColumnMetadata)this.metadata.columns().get(j);
                row.add(ClientAsyncResultSet.readValue(tupleReader, j, col));
            }
            res.add(new ClientSqlRow(row, this.metadata));
        }
        this.rows = Collections.unmodifiableList(res);
    }

    private static Object readValue(BinaryTupleReader in, int idx, ColumnMetadata col) {
        if (in.hasNullValue(idx)) {
            return null;
        }
        switch (col.type()) {
            case BOOLEAN: {
                return in.byteValue(idx) != 0;
            }
            case INT8: {
                return in.byteValue(idx);
            }
            case INT16: {
                return in.shortValue(idx);
            }
            case INT32: {
                return in.intValue(idx);
            }
            case INT64: {
                return in.longValue(idx);
            }
            case FLOAT: {
                return Float.valueOf(in.floatValue(idx));
            }
            case DOUBLE: {
                return in.doubleValue(idx);
            }
            case DECIMAL: {
                return in.decimalValue(idx, col.scale());
            }
            case DATE: {
                return in.dateValue(idx);
            }
            case TIME: {
                return in.timeValue(idx);
            }
            case DATETIME: {
                return in.dateTimeValue(idx);
            }
            case TIMESTAMP: {
                return in.timestampValue(idx);
            }
            case UUID: {
                return in.uuidValue(idx);
            }
            case BITMASK: {
                return in.bitmaskValue(idx);
            }
            case STRING: {
                return in.stringValue(idx);
            }
            case BYTE_ARRAY: {
                return in.bytesValue(idx);
            }
            case PERIOD: {
                return in.periodValue(idx);
            }
            case DURATION: {
                return in.durationValue(idx);
            }
            case NUMBER: {
                return in.numberValue(idx);
            }
        }
        throw new UnsupportedOperationException("Unsupported column type: " + col.type());
    }
}

