/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.api;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.sql.api.SessionImpl;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.property.PropertiesHolder;
import org.apache.ignite.internal.sql.engine.property.Property;
import org.apache.ignite.internal.sql.engine.session.SessionId;
import org.apache.ignite.sql.Session;
import org.jetbrains.annotations.Nullable;

public class SessionBuilderImpl
implements Session.SessionBuilder {
    public static final long DEFAULT_QUERY_TIMEOUT = 0L;
    public static final long DEFAULT_SESSION_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private final QueryProcessor qryProc;
    private long queryTimeout = 0L;
    private long sessionTimeout = DEFAULT_SESSION_TIMEOUT;
    private String schema = "PUBLIC";
    private int pageSize = 1024;
    private final Map<Property<?>, Object> props;

    SessionBuilderImpl(QueryProcessor qryProc, Map<Property<?>, Object> props) {
        this.qryProc = qryProc;
        this.props = props;
    }

    public long defaultQueryTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.queryTimeout, TimeUnit.MILLISECONDS);
    }

    public Session.SessionBuilder defaultQueryTimeout(long timeout, TimeUnit timeUnit) {
        this.queryTimeout = timeUnit.toMillis(timeout);
        return this;
    }

    public long idleTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.sessionTimeout, TimeUnit.MILLISECONDS);
    }

    public Session.SessionBuilder idleTimeout(long timeout, TimeUnit timeUnit) {
        this.sessionTimeout = timeUnit.toMillis(timeout);
        return this;
    }

    public String defaultSchema() {
        return this.schema;
    }

    public Session.SessionBuilder defaultSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public int defaultPageSize() {
        return this.pageSize;
    }

    public Session.SessionBuilder defaultPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    public Object property(String name) {
        return this.props.get(name);
    }

    public Session.SessionBuilder property(String name, @Nullable Object value) {
        Property<?> prop = QueryProperty.byName(name);
        if (prop != null) {
            this.props.put(prop, value);
        }
        return this;
    }

    public Session build() {
        PropertiesHolder propsHolder = PropertiesHolder.fromMap(Map.of(QueryProperty.QUERY_TIMEOUT, this.queryTimeout, QueryProperty.DEFAULT_SCHEMA, this.schema));
        SessionId sessionId = this.qryProc.createSession(this.sessionTimeout, propsHolder);
        return new SessionImpl(sessionId, this.qryProc, this.pageSize, this.sessionTimeout, propsHolder);
    }
}

