/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.watch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.lang.ByteArray;

public abstract class KeyCriterion {
    public abstract boolean contains(ByteArray var1);

    protected abstract KeyCriterion union(KeyCriterion var1, boolean var2);

    public KeyCriterion union(KeyCriterion keyCriterion) {
        return this.union(keyCriterion, false);
    }

    private static RuntimeException unsupportedUnionException(KeyCriterion keyCriterion1, KeyCriterion keyCriterion2) {
        return new UnsupportedOperationException("Can't calculate the union between " + keyCriterion1.getClass() + "and " + keyCriterion2.getClass() + " key criteria.");
    }

    public static class ExactCriterion
    extends KeyCriterion {
        private final ByteArray key;

        public ExactCriterion(ByteArray key) {
            this.key = key;
        }

        @Override
        public boolean contains(ByteArray key) {
            return this.key.equals((Object)key);
        }

        @Override
        protected KeyCriterion union(KeyCriterion keyCriterion, boolean swapTry) {
            if (keyCriterion instanceof ExactCriterion) {
                if (this.equals(keyCriterion)) {
                    return this;
                }
                return new CollectionCriterion(Arrays.asList(this.key, ((ExactCriterion)keyCriterion).key));
            }
            if (!swapTry) {
                return keyCriterion.union(this, true);
            }
            throw KeyCriterion.unsupportedUnionException(this, keyCriterion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactCriterion criterion = (ExactCriterion)o;
            return Objects.equals(this.key, criterion.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public ByteArray key() {
            return this.key;
        }
    }

    public static class CollectionCriterion
    extends KeyCriterion {
        private final Set<ByteArray> keys;

        public CollectionCriterion(Collection<ByteArray> keys) {
            this.keys = new HashSet<ByteArray>(keys);
        }

        @Override
        public boolean contains(ByteArray key) {
            return this.keys.contains(key);
        }

        @Override
        protected KeyCriterion union(KeyCriterion keyCriterion, boolean swapTry) {
            HashSet<ByteArray> newKeys = new HashSet<ByteArray>(this.keys);
            if (keyCriterion instanceof ExactCriterion) {
                newKeys.add(((ExactCriterion)keyCriterion).key);
                return new CollectionCriterion(newKeys);
            }
            if (keyCriterion instanceof CollectionCriterion) {
                newKeys.addAll(((CollectionCriterion)keyCriterion).keys);
                return new CollectionCriterion(newKeys);
            }
            if (!swapTry) {
                return keyCriterion.union(keyCriterion, true);
            }
            throw KeyCriterion.unsupportedUnionException(this, keyCriterion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionCriterion criterion = (CollectionCriterion)o;
            return Objects.equals(this.keys, criterion.keys);
        }

        public int hashCode() {
            return Objects.hash(this.keys);
        }

        public Set<ByteArray> keys() {
            return this.keys;
        }
    }

    public static class RangeCriterion
    extends KeyCriterion {
        private final ByteArray from;
        private final ByteArray to;

        public RangeCriterion(ByteArray from, ByteArray to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean contains(ByteArray key) {
            return key.compareTo(this.from) >= 0 && key.compareTo(this.to) < 0;
        }

        public static RangeCriterion fromPrefixKey(ByteArray prefixKey) {
            return new RangeCriterion(prefixKey, RangeCriterion.nextKey(prefixKey));
        }

        @Override
        protected KeyCriterion union(KeyCriterion keyCriterion, boolean swapTry) {
            ByteArray to;
            ByteArray from;
            if (keyCriterion instanceof ExactCriterion) {
                from = ((ExactCriterion)keyCriterion).key;
                to = RangeCriterion.nextKey(from);
            } else if (keyCriterion instanceof CollectionCriterion) {
                from = Collections.min(((CollectionCriterion)keyCriterion).keys);
                to = RangeCriterion.nextKey(Collections.max(((CollectionCriterion)keyCriterion).keys));
            } else if (keyCriterion instanceof RangeCriterion) {
                from = ((RangeCriterion)keyCriterion).from;
                to = ((RangeCriterion)keyCriterion).to;
            } else {
                if (!swapTry) {
                    return keyCriterion.union(this, true);
                }
                throw KeyCriterion.unsupportedUnionException(this, keyCriterion);
            }
            return new RangeCriterion(RangeCriterion.minFromNullables(this.from, from), RangeCriterion.maxFromNullables(this.to, to));
        }

        private static ByteArray maxFromNullables(ByteArray key1, ByteArray key2) {
            if (key1 != null && key2 != null) {
                return key1.compareTo(key2) >= 0 ? key1 : key2;
            }
            return null;
        }

        private static ByteArray minFromNullables(ByteArray key1, ByteArray key2) {
            if (key1 != null && key2 != null) {
                return key1.compareTo(key2) < 0 ? key1 : key2;
            }
            return null;
        }

        private static ByteArray nextKey(ByteArray key) {
            byte[] bytes = Arrays.copyOf(key.bytes(), key.bytes().length);
            if (bytes[bytes.length - 1] != 127) {
                int n = bytes.length - 1;
                bytes[n] = (byte)(bytes[n] + 1);
            } else {
                bytes = Arrays.copyOf(bytes, bytes.length + 1);
            }
            return new ByteArray(bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangeCriterion criterion = (RangeCriterion)o;
            return Objects.equals(this.from, criterion.from) && Objects.equals(this.to, criterion.to);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }

        public ByteArray from() {
            return this.from;
        }

        public ByteArray to() {
            return this.to;
        }
    }
}

