/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.raft.configuration.RaftConfiguration;
import org.apache.ignite.internal.raft.configuration.VolatileRaftConfiguration;
import org.apache.ignite.internal.raft.server.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.server.RaftGroupOptions;
import org.apache.ignite.internal.raft.server.RaftServer;
import org.apache.ignite.internal.raft.server.impl.JraftServerImpl;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.TopologyService;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.service.RaftGroupListener;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.rpc.impl.RaftGroupServiceImpl;
import org.apache.ignite.raft.jraft.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class Loza
implements IgniteComponent {
    private static final RaftMessagesFactory FACTORY = new RaftMessagesFactory();
    public static final String CLIENT_POOL_NAME = "Raft-Group-Client";
    private static final int CLIENT_POOL_SIZE = Math.min(Utils.cpus() * 3, 20);
    private static final int RETRY_TIMEOUT = 10000;
    private static final int RPC_TIMEOUT = 3000;
    private static final int DELAY = 200;
    private static final IgniteLogger LOG = Loggers.forClass(Loza.class);
    private final ClusterService clusterNetSvc;
    private final RaftServer raftServer;
    private final ScheduledExecutorService executor;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final RaftConfiguration raftConfiguration;

    public Loza(ClusterService clusterNetSvc, RaftConfiguration raftConfiguration, Path dataPath, HybridClock clock) {
        this(clusterNetSvc, raftConfiguration, dataPath, clock, null);
    }

    public Loza(ClusterService clusterNetSvc, RaftConfiguration raftConfiguration, Path dataPath, HybridClock clock, @Nullable PendingComparableValuesTracker<HybridTimestamp> safeTimeTracker) {
        this.clusterNetSvc = clusterNetSvc;
        this.raftConfiguration = raftConfiguration;
        NodeOptions options = new NodeOptions();
        options.setClock(clock);
        options.setSafeTimeTracker(safeTimeTracker);
        this.raftServer = new JraftServerImpl(clusterNetSvc, dataPath, options);
        this.executor = new ScheduledThreadPoolExecutor(CLIENT_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(NamedThreadFactory.threadPrefix((String)clusterNetSvc.localConfiguration().getName(), (String)CLIENT_POOL_NAME), LOG));
    }

    public void start() {
        this.raftServer.start();
    }

    public void stop() throws Exception {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.raftServer.stop();
    }

    public boolean shouldHaveRaftGroupLocally(Collection<ClusterNode> raftNodes) {
        String locNodeName = this.clusterNetSvc.topologyService().localMember().name();
        return raftNodes.stream().anyMatch(n -> locNodeName.equals(n.name()));
    }

    public CompletableFuture<RaftGroupService> prepareRaftGroup(ReplicationGroupId groupId, List<ClusterNode> nodes, Supplier<RaftGroupListener> lsnrSupplier, RaftGroupOptions groupOptions) throws NodeStoppingException {
        return this.prepareRaftGroup(groupId, nodes, lsnrSupplier, () -> RaftGroupEventsListener.noopLsnr, groupOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftGroupService> prepareRaftGroup(ReplicationGroupId groupId, List<ClusterNode> nodes, Supplier<RaftGroupListener> lsnrSupplier, Supplier<RaftGroupEventsListener> raftGrpEvtsLsnrSupplier, RaftGroupOptions groupOptions) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            CompletableFuture<RaftGroupService> completableFuture = this.prepareRaftGroupInternal(groupId, nodes, lsnrSupplier, raftGrpEvtsLsnrSupplier, groupOptions);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<RaftGroupService> prepareRaftGroupInternal(ReplicationGroupId groupId, List<ClusterNode> nodes, Supplier<RaftGroupListener> lsnrSupplier, Supplier<RaftGroupEventsListener> raftGrpEvtsLsnrSupplier, RaftGroupOptions groupOptions) {
        assert (!nodes.isEmpty());
        List<Peer> peers = nodes.stream().map(n -> new Peer(n.address())).collect(Collectors.toList());
        boolean hasLocalRaft = this.shouldHaveRaftGroupLocally(nodes);
        if (hasLocalRaft) {
            LOG.info("Start new raft node for group={} with initial peers={}", new Object[]{groupId, peers});
            if (!this.raftServer.startRaftGroup(groupId, raftGrpEvtsLsnrSupplier.get(), lsnrSupplier.get(), peers, groupOptions)) {
                throw new IgniteInternalException(IgniteStringFormatter.format((String)"Raft group on the node is already started [raftGrp={}]", (Object[])new Object[]{groupId}));
            }
        }
        return RaftGroupServiceImpl.start(groupId, this.clusterNetSvc, FACTORY, 10000, 3000, peers, true, 200L, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRaftGroupNode(ReplicationGroupId grpId, Collection<ClusterNode> nodes, RaftGroupListener lsnr, RaftGroupEventsListener raftGrpEvtsLsnr, RaftGroupOptions groupOptions) throws NodeStoppingException {
        assert (!nodes.isEmpty());
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            List<Peer> peers = nodes.stream().map(n -> new Peer(n.address())).collect(Collectors.toList());
            LOG.info("Start new raft node for group={} with initial peers={}", new Object[]{grpId, peers});
            if (!this.raftServer.startRaftGroup(grpId, raftGrpEvtsLsnr, lsnr, peers, groupOptions)) {
                throw new IgniteInternalException(IgniteStringFormatter.format((String)"Raft group on the node is already started [raftGrp={}]", (Object[])new Object[]{grpId}));
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftGroupService> startRaftGroupService(ReplicationGroupId grpId, Collection<ClusterNode> nodes) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        List<Peer> peers = nodes.stream().map(n -> new Peer(n.address())).collect(Collectors.toList());
        try {
            CompletableFuture<RaftGroupService> completableFuture = RaftGroupServiceImpl.start(grpId, this.clusterNetSvc, FACTORY, 10000, 3000, peers, true, 200L, this.executor);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void stopRaftGroup(ReplicationGroupId groupId) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            LOG.info("Stop raft group={}", new Object[]{groupId});
            this.raftServer.stopRaftGroup(groupId);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public MessagingService messagingService() {
        return this.clusterNetSvc.messagingService();
    }

    public TopologyService topologyService() {
        return this.clusterNetSvc.topologyService();
    }

    public VolatileRaftConfiguration volatileRaft() {
        return this.raftConfiguration.volatileRaft();
    }

    @TestOnly
    public ClusterService service() {
        return this.clusterNetSvc;
    }

    @TestOnly
    public RaftServer server() {
        return this.raftServer;
    }

    @TestOnly
    public Set<ReplicationGroupId> startedGroups() {
        return this.raftServer.startedGroups();
    }
}

