/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.manager.IgniteTables;

public class ClientSchemasGetRequest {
    public static CompletableFuture<Object> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteTables tables) {
        TableImpl table = ClientTableCommon.readTable(in, tables);
        if (in.tryUnpackNil()) {
            out.packMapHeader(1);
            SchemaDescriptor schema = table.schemaView().schema();
            if (schema == null) {
                throw new IgniteException("Schema registry is not initialized.");
            }
            ClientTableCommon.writeSchema(out, schema.version(), schema);
        } else {
            int cnt = in.unpackArrayHeader();
            out.packMapHeader(cnt);
            for (int i = 0; i < cnt; ++i) {
                int schemaVer = in.unpackInt();
                SchemaDescriptor schema = table.schemaView().schema(schemaVer);
                ClientTableCommon.writeSchema(out, schemaVer, schema);
            }
        }
        return null;
    }
}

