/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.table.distributed.message.HasDataRequest;
import org.apache.ignite.internal.table.distributed.message.HasDataRequestBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HasDataRequestImpl
implements HasDataRequest {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final int partitionId;
    @IgniteToStringInclude
    private final UUID tableId;

    private HasDataRequestImpl(int partitionId, UUID tableId) {
        this.partitionId = partitionId;
        this.tableId = tableId;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    @Override
    public UUID tableId() {
        return this.tableId;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(HasDataRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HasDataRequestImpl otherMessage = (HasDataRequestImpl)other;
        return Objects.equals(this.tableId, otherMessage.tableId) && this.partitionId == otherMessage.partitionId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.partitionId, this.tableId);
        return result;
    }

    public static HasDataRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements HasDataRequestBuilder {
        private int partitionId;
        private UUID tableId;

        private Builder() {
        }

        @Override
        public HasDataRequestBuilder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public HasDataRequestBuilder tableId(UUID tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public int partitionId() {
            return this.partitionId;
        }

        @Override
        public UUID tableId() {
            return this.tableId;
        }

        @Override
        public HasDataRequest build() {
            return new HasDataRequestImpl(this.partitionId, this.tableId);
        }
    }
}

