/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class CheckpointPages {
    private final Set<FullPageId> segmentPages;
    private final CompletableFuture<?> allowToReplace;

    public CheckpointPages(Set<FullPageId> pages, CompletableFuture<?> replaceFuture) {
        this.segmentPages = pages;
        this.allowToReplace = replaceFuture;
    }

    public boolean allowToSave(FullPageId fullPageId) throws IgniteInternalCheckedException {
        try {
            IgniteUtils.getUninterruptibly(this.allowToReplace);
        }
        catch (ExecutionException e) {
            throw new IgniteInternalCheckedException(e.getCause());
        }
        catch (CancellationException e) {
            throw new IgniteInternalCheckedException((Throwable)e);
        }
        return this.segmentPages.contains(fullPageId);
    }

    public boolean contains(FullPageId fullPageId) {
        return this.segmentPages.contains(fullPageId);
    }

    public boolean markAsSaved(FullPageId fullPageId) {
        return this.segmentPages.remove(fullPageId);
    }

    public int size() {
        return this.segmentPages.size();
    }
}

