/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.app;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgnitionManager;
import org.apache.ignite.internal.app.EnvironmentDefaultValueProvider;
import org.apache.ignite.network.NetworkAddress;
import picocli.CommandLine;

@CommandLine.Command(name="runner")
public class IgniteRunner
implements Callable<CompletableFuture<Ignite>> {
    @CommandLine.ArgGroup
    private ConfigOptions configOptions = new ConfigOptions();
    @CommandLine.Option(names={"--join"}, description={"Seed nodes."}, split=",")
    private NetworkAddress[] seedNodes;
    @CommandLine.Option(names={"--work-dir"}, description={"Path to node working directory."}, required=true)
    private Path workDir;
    @CommandLine.Option(names={"--node-name"}, description={"Node name."}, required=true)
    private String nodeName;

    @Override
    public CompletableFuture<Ignite> call() throws Exception {
        Path configPath = this.configOptions.configPath;
        if (configPath != null && this.seedNodes == null) {
            return IgnitionManager.start((String)this.nodeName, (Path)configPath.toAbsolutePath(), (Path)this.workDir, null);
        }
        return IgnitionManager.start((String)this.nodeName, (String)this.getConfigStr(), (Path)this.workDir);
    }

    private String getConfigStr() {
        Config configOptions = this.parseConfigOptions();
        Config configArgs = this.parseConfigArgs();
        Config config = configArgs.withFallback((ConfigMergeable)configOptions).resolve();
        return config.isEmpty() ? null : config.root().render(ConfigRenderOptions.concise().setJson(false));
    }

    private Config parseConfigOptions() {
        Path configPath = this.configOptions.configPath;
        String configString = this.configOptions.configString;
        if (configPath != null) {
            return ConfigFactory.parseFile((File)configPath.toFile(), (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false));
        }
        if (configString != null) {
            return ConfigFactory.parseString((String)configString);
        }
        return ConfigFactory.empty();
    }

    private Config parseConfigArgs() {
        HashMap configMap = new HashMap();
        if (this.seedNodes != null) {
            List strings = Arrays.stream(this.seedNodes).map(NetworkAddress::toString).collect(Collectors.toList());
            configMap.put("network.nodeFinder.netClusterNodes", strings);
        }
        return ConfigFactory.parseMap(configMap);
    }

    public static CompletableFuture<Ignite> start(String ... args) {
        CommandLine commandLine = new CommandLine((Object)new IgniteRunner());
        commandLine.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new EnvironmentDefaultValueProvider());
        commandLine.registerConverter(NetworkAddress.class, value -> {
            try {
                return NetworkAddress.from((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new CommandLine.TypeConversionException(e.getMessage());
            }
        });
        int exitCode = commandLine.execute(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        return (CompletableFuture)commandLine.getExecutionResult();
    }

    public static void main(String[] args) {
        try {
            IgniteRunner.start(args).get();
        }
        catch (InterruptedException | ExecutionException e) {
            System.out.println("Error when starting the node: " + e.getMessage());
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private static class ConfigOptions {
        @CommandLine.Option(names={"--config-path"}, description={"Path to node configuration file in HOCON format."})
        private Path configPath;
        @CommandLine.Option(names={"--config-string"}, description={"Node configuration in HOCON format."})
        private String configString;

        private ConfigOptions() {
        }
    }
}

