/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlCreateSchema
extends SqlCreate {
    private final SqlIdentifier name;

    public IgniteSqlCreateSchema(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name) {
        super((SqlOperator)new Operator(ifNotExists), pos, false, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("SCHEMA");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("CREATE SCHEMA", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlCreateSchema(pos, this.existFlag(), (SqlIdentifier)operands[0]);
        }
    }
}

