/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.ResponseEntryBuilder;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ResponseEntryDeserializer
implements MessageDeserializer<SnapshotMvDataResponse.ResponseEntry> {
    private final ResponseEntryBuilder msg;

    ResponseEntryDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.responseEntry();
    }

    public Class<SnapshotMvDataResponse.ResponseEntry> klass() {
        return SnapshotMvDataResponse.ResponseEntry.class;
    }

    public SnapshotMvDataResponse.ResponseEntry getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readBoxedInt("commitTableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTableId((Integer)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readUuid("rowId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.rowId((UUID)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readList("rowVersions", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.rowVersions((List<BinaryRowMessage>)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readLongArray("timestamps");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamps((long[])tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotMvDataResponse.ResponseEntry.class);
    }
}

