/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccess;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotWriter;
import org.apache.ignite.internal.table.distributed.raft.snapshot.SnapshotUri;
import org.apache.ignite.internal.table.distributed.raft.snapshot.incoming.IncomingSnapshotCopier;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshotReader;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite.internal.table.distributed.raft.snapshot.startup.StartupPartitionSnapshotReader;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.option.SnapshotCopierOptions;
import org.apache.ignite.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotStorage
implements SnapshotStorage {
    private static final int DEFAULT_WAIT_FOR_METADATA_CATCHUP_MS = 3000;
    private final TopologyService topologyService;
    private final OutgoingSnapshotsManager outgoingSnapshotsManager;
    private final String snapshotUri;
    private final RaftOptions raftOptions;
    private final PartitionAccess partition;
    private final CatalogService catalogService;
    @Nullable
    private final RaftOutter.SnapshotMeta startupSnapshotMeta;
    private final Executor incomingSnapshotsExecutor;
    private final long waitForMetadataCatchupMs;
    @Nullable
    private SnapshotThrottle snapshotThrottle;
    private final AtomicBoolean startupSnapshotOpened = new AtomicBoolean();

    public PartitionSnapshotStorage(TopologyService topologyService, OutgoingSnapshotsManager outgoingSnapshotsManager, String snapshotUri, RaftOptions raftOptions, PartitionAccess partition, CatalogService catalogService, @Nullable RaftOutter.SnapshotMeta startupSnapshotMeta, Executor incomingSnapshotsExecutor) {
        this(topologyService, outgoingSnapshotsManager, snapshotUri, raftOptions, partition, catalogService, startupSnapshotMeta, incomingSnapshotsExecutor, 3000L);
    }

    public PartitionSnapshotStorage(TopologyService topologyService, OutgoingSnapshotsManager outgoingSnapshotsManager, String snapshotUri, RaftOptions raftOptions, PartitionAccess partition, CatalogService catalogService, @Nullable RaftOutter.SnapshotMeta startupSnapshotMeta, Executor incomingSnapshotsExecutor, long waitForMetadataCatchupMs) {
        this.topologyService = topologyService;
        this.outgoingSnapshotsManager = outgoingSnapshotsManager;
        this.snapshotUri = snapshotUri;
        this.raftOptions = raftOptions;
        this.partition = partition;
        this.catalogService = catalogService;
        this.startupSnapshotMeta = startupSnapshotMeta;
        this.incomingSnapshotsExecutor = incomingSnapshotsExecutor;
        this.waitForMetadataCatchupMs = waitForMetadataCatchupMs;
    }

    public TopologyService topologyService() {
        return this.topologyService;
    }

    public OutgoingSnapshotsManager outgoingSnapshotsManager() {
        return this.outgoingSnapshotsManager;
    }

    public String snapshotUri() {
        return this.snapshotUri;
    }

    public RaftOptions raftOptions() {
        return this.raftOptions;
    }

    public PartitionAccess partition() {
        return this.partition;
    }

    public CatalogService catalogService() {
        return this.catalogService;
    }

    public RaftOutter.SnapshotMeta startupSnapshotMeta() {
        if (this.startupSnapshotMeta == null) {
            throw new IllegalStateException("Storage is empty, so startup snapshot should not be read");
        }
        return this.startupSnapshotMeta;
    }

    @Nullable
    public SnapshotThrottle snapshotThrottle() {
        return this.snapshotThrottle;
    }

    public Executor getIncomingSnapshotsExecutor() {
        return this.incomingSnapshotsExecutor;
    }

    public boolean init(Void opts) {
        return true;
    }

    public void shutdown() {
    }

    public boolean setFilterBeforeCopyRemote() {
        return false;
    }

    public SnapshotWriter create() {
        return new PartitionSnapshotWriter(this);
    }

    @Nullable
    public SnapshotReader open() {
        if (this.startupSnapshotOpened.compareAndSet(false, true)) {
            if (this.startupSnapshotMeta == null) {
                return null;
            }
            return new StartupPartitionSnapshotReader(this);
        }
        return new OutgoingSnapshotReader(this);
    }

    public SnapshotReader copyFrom(String uri, SnapshotCopierOptions opts) {
        throw new UnsupportedOperationException("Synchronous snapshot copy is not supported.");
    }

    public SnapshotCopier startToCopyFrom(String uri, SnapshotCopierOptions opts) {
        SnapshotUri snapshotUri = SnapshotUri.fromStringUri(uri);
        IncomingSnapshotCopier copier = new IncomingSnapshotCopier(this, snapshotUri, this.waitForMetadataCatchupMs);
        copier.start();
        return copier;
    }

    public void setSnapshotThrottle(SnapshotThrottle snapshotThrottle) {
        this.snapshotThrottle = snapshotThrottle;
    }
}

