/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot.local;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.LocalFileMetaBuilder;
import org.apache.ignite.raft.jraft.entity.LocalFileMetaOutter;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotMetaTable;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotStorage;
import org.apache.ignite.raft.jraft.util.Utils;

public class LocalSnapshotWriter
extends SnapshotWriter {
    private static final IgniteLogger LOG = Loggers.forClass(LocalSnapshotWriter.class);
    private final LocalSnapshotMetaTable metaTable;
    private final String path;
    private final LocalSnapshotStorage snapshotStorage;
    private final RaftMessagesFactory msgFactory;

    public LocalSnapshotWriter(String path, LocalSnapshotStorage snapshotStorage, RaftOptions raftOptions) {
        this.snapshotStorage = snapshotStorage;
        this.path = path;
        this.metaTable = new LocalSnapshotMetaTable(raftOptions);
        this.msgFactory = raftOptions.getRaftMessagesFactory();
    }

    @Override
    public boolean init(Void v) {
        File dir = new File(this.path);
        if (!Utils.mkdir(dir)) {
            LOG.error("Fail to create directory {}.", new Object[]{this.path});
            this.setError(RaftError.EIO, "Fail to create directory  %s", this.path);
            return false;
        }
        String metaPath = this.path + File.separator + "__raft_snapshot_meta";
        File metaFile = new File(metaPath);
        try {
            if (metaFile.exists()) {
                return this.metaTable.loadFromFile(metaPath);
            }
        }
        catch (IOException e) {
            LOG.error("Fail to load snapshot meta from {}.", new Object[]{metaPath, e});
            this.setError(RaftError.EIO, "Fail to load snapshot meta from %s", metaPath);
            return false;
        }
        return true;
    }

    public long getSnapshotIndex() {
        return this.metaTable.hasMeta() ? this.metaTable.getMeta().lastIncludedIndex() : 0L;
    }

    @Override
    public void shutdown() {
        Utils.closeQuietly(this);
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    @Override
    public void close(boolean keepDataOnError) throws IOException {
        this.snapshotStorage.close(this, keepDataOnError);
    }

    @Override
    public boolean saveMeta(RaftOutter.SnapshotMeta meta) {
        this.metaTable.setMeta(meta);
        return true;
    }

    public boolean sync() throws IOException {
        return this.metaTable.saveToFile(this.path + File.separator + "__raft_snapshot_meta");
    }

    @Override
    public boolean addFile(String fileName, Message fileMeta) {
        LocalFileMetaBuilder metaBuilder = this.msgFactory.localFileMeta();
        if (fileMeta != null) {
            LocalFileMetaOutter.FileSource source = ((LocalFileMetaOutter.LocalFileMeta)fileMeta).source();
            metaBuilder.sourceNumber(source == null ? 0 : source.getNumber());
            metaBuilder.checksum(((LocalFileMetaOutter.LocalFileMeta)fileMeta).checksum());
        }
        LocalFileMetaOutter.LocalFileMeta meta = metaBuilder.build();
        return this.metaTable.addFile(fileName, meta);
    }

    @Override
    public boolean removeFile(String fileName) {
        return this.metaTable.removeFile(fileName);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<String> listFiles() {
        return this.metaTable.listFiles();
    }

    @Override
    public Message getFileMeta(String fileName) {
        return this.metaTable.getFileMeta(fileName);
    }
}

