/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage.serialization;

import org.apache.ignite.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogMarshallerException;
import org.apache.ignite.internal.catalog.storage.serialization.UpdateLogMarshaller;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataInput;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataOutput;
import org.jetbrains.annotations.TestOnly;

public class UpdateLogMarshallerImpl
implements UpdateLogMarshaller {
    private static final int PROTOCOL_VERSION = 1;
    private static final int INITIAL_BUFFER_CAPACITY = 256;
    private final CatalogEntrySerializerProvider serializers;

    public UpdateLogMarshallerImpl() {
        this.serializers = CatalogEntrySerializerProvider.DEFAULT_PROVIDER;
    }

    @TestOnly
    public UpdateLogMarshallerImpl(CatalogEntrySerializerProvider serializers) {
        this.serializers = serializers;
    }

    @Override
    public byte[] marshall(UpdateLogEvent update) {
        byte[] byArray;
        IgniteUnsafeDataOutput output = new IgniteUnsafeDataOutput(256);
        try {
            output.writeShort(1);
            output.writeShort(update.typeId());
            this.serializers.get(update.typeId()).writeTo(update, (IgniteDataOutput)output);
            byArray = output.array();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new CatalogMarshallerException(t);
            }
        }
        output.close();
        return byArray;
    }

    @Override
    public UpdateLogEvent unmarshall(byte[] bytes) {
        UpdateLogEvent updateLogEvent;
        IgniteUnsafeDataInput input = new IgniteUnsafeDataInput(bytes);
        try {
            short version = input.readShort();
            if (version > 1) {
                throw new IllegalStateException(IgniteStringFormatter.format((String)"An object could not be deserialized because it was using a newer version of the serialization protocol [objectVersion={}, supported={}]", (Object[])new Object[]{(int)version, 1}));
            }
            short typeId = input.readShort();
            updateLogEvent = (UpdateLogEvent)this.serializers.get(typeId).readFrom((IgniteDataInput)input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new CatalogMarshallerException(t);
            }
        }
        input.close();
        return updateLogEvent;
    }
}

