/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler.replacement;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.exceptions.ContentLengthExceededHandler;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=ContentLengthExceededHandler.class)
@Requires(classes={ContentLengthExceededException.class, ExceptionHandler.class})
public class ContentLengthExceededHandlerReplacement
implements ExceptionHandler<ContentLengthExceededException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, ContentLengthExceededException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.REQUEST_ENTITY_TOO_LARGE).detail(exception.getMessage()));
    }
}

