/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.jdbc;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcTableMeta;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.schema.catalog.CatalogToSchemaDescriptorConverter;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.Pair;
import org.jetbrains.annotations.Nullable;

public class JdbcMetadataCatalog {
    private static final String PK = "PK_";
    private static final String TBL_TYPE = "TABLE";
    private final ClockService clockService;
    private final SchemaSyncService schemaSyncService;
    private final CatalogService catalogService;
    private static final Comparator<Pair<String, Column>> bySchemaThenTabNameThenColOrder = Comparator.comparing(Pair::getFirst).thenComparingInt(o -> ((Column)o.getSecond()).positionInRow());
    private static final Comparator<CatalogTableDescriptor> byTblTypeThenSchemaThenTblName = Comparator.comparing(CatalogObjectDescriptor::name);

    public JdbcMetadataCatalog(ClockService clockService, SchemaSyncService schemaSyncService, CatalogService catalogService) {
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.catalogService = catalogService;
    }

    public CompletableFuture<Collection<JdbcPrimaryKeyMeta>> getPrimaryKeys(String schemaNamePtrn, String tblNamePtrn) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        return this.tablesAtNow().thenApply(tables -> tables.stream().filter(t -> JdbcMetadataCatalog.tableNameAndSchemaMatches(t, schemaNameRegex, tlbNameRegex)).map(this::createPrimaryKeyMeta).collect(Collectors.toSet()));
    }

    private CompletableFuture<Collection<CatalogTableDescriptor>> tablesAtNow() {
        HybridTimestamp now = this.clockService.now();
        return this.schemaSyncService.waitForMetadataCompleteness(now).thenApply(unused -> this.catalogService.tables(this.catalogService.activeCatalogVersion(now.longValue())));
    }

    public CompletableFuture<List<JdbcTableMeta>> getTablesMeta(String schemaNamePtrn, String tblNamePtrn, String[] tblTypes) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        return this.tablesAtNow().thenApply(tables -> tables.stream().filter(t -> JdbcMetadataCatalog.tableNameAndSchemaMatches(t, schemaNameRegex, tlbNameRegex)).sorted(byTblTypeThenSchemaThenTblName).map(t -> new JdbcTableMeta("PUBLIC", t.name(), TBL_TYPE)).collect(Collectors.toList()));
    }

    private static boolean tableNameAndSchemaMatches(CatalogTableDescriptor table, @Nullable String schemaNameRegex, @Nullable String tlbNameRegex) {
        return JdbcMetadataCatalog.matches("PUBLIC", schemaNameRegex) && JdbcMetadataCatalog.matches(table.name(), tlbNameRegex);
    }

    public CompletableFuture<Collection<JdbcColumnMeta>> getColumnsMeta(String schemaNamePtrn, String tblNamePtrn, String colNamePtrn) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        String colNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(colNamePtrn);
        return this.tablesAtNow().thenApply(tablesList -> tablesList.stream().filter(t -> JdbcMetadataCatalog.tableNameAndSchemaMatches(t, schemaNameRegex, tlbNameRegex)).flatMap(tbl -> {
            SchemaDescriptor schema = CatalogToSchemaDescriptorConverter.convert((CatalogTableDescriptor)tbl, (int)tbl.tableVersion());
            return schema.columns().stream().map(column -> new Pair((Object)tbl.name(), column));
        }).filter(e -> JdbcMetadataCatalog.matches(((Column)e.getSecond()).name(), colNameRegex)).sorted(bySchemaThenTabNameThenColOrder).map(pair -> this.createColumnMeta((String)pair.getFirst(), (Column)pair.getSecond())).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public CompletableFuture<Collection<String>> getSchemasMeta(String schemaNamePtrn) {
        TreeSet<String> schemas = new TreeSet<String>();
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        if (JdbcMetadataCatalog.matches("PUBLIC", schemaNameRegex)) {
            schemas.add("PUBLIC");
        }
        return this.tablesAtNow().thenApply(tables -> tables.stream().map(tbl -> "PUBLIC").filter(schema -> JdbcMetadataCatalog.matches(schema, schemaNameRegex)).collect(Collectors.toCollection(() -> schemas)));
    }

    private JdbcPrimaryKeyMeta createPrimaryKeyMeta(CatalogTableDescriptor tbl) {
        String keyName = PK + tbl.name();
        List keyColNames = List.copyOf(tbl.primaryKeyColumns());
        return new JdbcPrimaryKeyMeta("PUBLIC", tbl.name(), keyName, keyColNames);
    }

    private JdbcColumnMeta createColumnMeta(String tblName, Column col) {
        NativeType colType = col.type();
        return new JdbcColumnMeta(col.name(), "PUBLIC", tblName, col.name(), colType.spec().asColumnType(), Commons.nativeTypePrecision((NativeType)colType), Commons.nativeTypeScale((NativeType)colType), col.nullable());
    }

    private static boolean matches(@Nullable String str, @Nullable String sqlPtrn) {
        if (str == null) {
            return false;
        }
        if (sqlPtrn == null) {
            return true;
        }
        return str.matches(sqlPtrn);
    }

    @Nullable
    private static String translateSqlWildcardsToRegex(String sqlPtrn) {
        if (sqlPtrn == null || sqlPtrn.isEmpty()) {
            return sqlPtrn;
        }
        Object toRegex = " " + sqlPtrn;
        toRegex = ((String)toRegex).replaceAll("([\\[\\]{}()*+?.\\\\\\\\^$|])", "\\\\$1");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)%", "$1$2.*");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)_", "$1$2.");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])(\\\\\\\\(?>\\\\\\\\\\\\\\\\)*\\\\\\\\)*\\\\\\\\([_|%])", "$1$2$3");
        return ((String)toRegex).substring(1);
    }
}

