/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.BatchRewindStrategy;
import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.EventHandlerBase;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.ExceptionHandlers;
import com.lmax.disruptor.RewindAction;
import com.lmax.disruptor.RewindHandler;
import com.lmax.disruptor.RewindableEventHandler;
import com.lmax.disruptor.RewindableException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public final class BatchEventProcessor<T>
implements EventProcessor {
    private static final int IDLE = 0;
    private static final int HALTED = 1;
    private static final int RUNNING = 2;
    private final AtomicInteger running = new AtomicInteger(0);
    private ExceptionHandler<? super T> exceptionHandler;
    private final DataProvider<T> dataProvider;
    private final SequenceBarrier sequenceBarrier;
    private final EventHandlerBase<? super T> eventHandler;
    private final int batchLimitOffset;
    private final Sequence sequence = new Sequence(-1L);
    private final RewindHandler rewindHandler;
    private int retriesAttempted = 0;

    BatchEventProcessor(DataProvider<T> dataProvider, SequenceBarrier sequenceBarrier, EventHandlerBase<? super T> eventHandler, int maxBatchSize, BatchRewindStrategy batchRewindStrategy) {
        this.dataProvider = dataProvider;
        this.sequenceBarrier = sequenceBarrier;
        this.eventHandler = eventHandler;
        if (maxBatchSize < 1) {
            throw new IllegalArgumentException("maxBatchSize must be greater than 0");
        }
        this.batchLimitOffset = maxBatchSize - 1;
        this.rewindHandler = eventHandler instanceof RewindableEventHandler ? new TryRewindHandler(batchRewindStrategy) : new NoRewindHandler();
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void halt() {
        this.running.set(1);
        this.sequenceBarrier.alert();
    }

    @Override
    public boolean isRunning() {
        return this.running.get() != 0;
    }

    public void setExceptionHandler(ExceptionHandler<? super T> exceptionHandler) {
        if (null == exceptionHandler) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        int witnessValue = this.running.compareAndExchange(0, 2);
        if (witnessValue == 0) {
            this.sequenceBarrier.clearAlert();
            this.notifyStart();
            try {
                if (this.running.get() != 2) return;
                this.processEvents();
                return;
            }
            finally {
                this.notifyShutdown();
                this.running.set(0);
            }
        } else {
            if (witnessValue == 2) {
                throw new IllegalStateException("Thread is already running");
            }
            this.earlyExit();
        }
    }

    private void processEvents() {
        Object event = null;
        long nextSequence = this.sequence.get() + 1L;
        while (true) {
            long startOfBatchSequence = ++nextSequence;
            try {
                try {
                    long availableSequence = this.sequenceBarrier.waitFor(nextSequence);
                    long endOfBatchSequence = Math.min(nextSequence + (long)this.batchLimitOffset, availableSequence);
                    if (nextSequence <= endOfBatchSequence) {
                        this.eventHandler.onBatchStart(endOfBatchSequence - nextSequence + 1L, availableSequence - nextSequence + 1L);
                    }
                    while (nextSequence <= endOfBatchSequence) {
                        event = this.dataProvider.get(nextSequence);
                        this.eventHandler.onEvent(event, nextSequence, nextSequence == endOfBatchSequence);
                        ++nextSequence;
                    }
                    this.retriesAttempted = 0;
                    this.sequence.set(endOfBatchSequence);
                }
                catch (RewindableException e) {
                    nextSequence = this.rewindHandler.attemptRewindGetNextSequence(e, startOfBatchSequence);
                }
                continue;
            }
            catch (TimeoutException e) {
                this.notifyTimeout(this.sequence.get());
                continue;
            }
            catch (AlertException ex) {
                if (this.running.get() == 2) continue;
            }
            catch (Throwable ex) {
                this.handleEventException(ex, nextSequence, event);
                this.sequence.set(nextSequence);
                continue;
            }
            break;
        }
    }

    private void earlyExit() {
        this.notifyStart();
        this.notifyShutdown();
    }

    private void notifyTimeout(long availableSequence) {
        try {
            this.eventHandler.onTimeout(availableSequence);
        }
        catch (Throwable e) {
            this.handleEventException(e, availableSequence, null);
        }
    }

    private void notifyStart() {
        try {
            this.eventHandler.onStart();
        }
        catch (Throwable ex) {
            this.handleOnStartException(ex);
        }
    }

    private void notifyShutdown() {
        try {
            this.eventHandler.onShutdown();
        }
        catch (Throwable ex) {
            this.handleOnShutdownException(ex);
        }
    }

    private void handleEventException(Throwable ex, long sequence, T event) {
        this.getExceptionHandler().handleEventException(ex, sequence, event);
    }

    private void handleOnStartException(Throwable ex) {
        this.getExceptionHandler().handleOnStartException(ex);
    }

    private void handleOnShutdownException(Throwable ex) {
        this.getExceptionHandler().handleOnShutdownException(ex);
    }

    private ExceptionHandler<? super T> getExceptionHandler() {
        ExceptionHandler<Object> handler = this.exceptionHandler;
        return handler == null ? ExceptionHandlers.defaultHandler() : handler;
    }

    private static class NoRewindHandler
    implements RewindHandler {
        private NoRewindHandler() {
        }

        @Override
        public long attemptRewindGetNextSequence(RewindableException e, long startOfBatchSequence) {
            throw new UnsupportedOperationException("Rewindable Exception thrown from a non-rewindable event handler", e);
        }
    }

    private class TryRewindHandler
    implements RewindHandler {
        private final BatchRewindStrategy batchRewindStrategy;

        TryRewindHandler(BatchRewindStrategy batchRewindStrategy) {
            this.batchRewindStrategy = batchRewindStrategy;
        }

        @Override
        public long attemptRewindGetNextSequence(RewindableException e, long startOfBatchSequence) throws RewindableException {
            if (this.batchRewindStrategy.handleRewindException(e, ++BatchEventProcessor.this.retriesAttempted) == RewindAction.REWIND) {
                return startOfBatchSequence;
            }
            BatchEventProcessor.this.retriesAttempted = 0;
            throw e;
        }
    }
}

