/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractCreateIndexCommand;
import org.apache.ignite.internal.catalog.commands.CreateSortedIndexCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.util.CollectionUtils;

public class CreateSortedIndexCommand
extends AbstractCreateIndexCommand {
    private final List<CatalogColumnCollation> collations;

    public static CreateSortedIndexCommandBuilder builder() {
        return new Builder();
    }

    private CreateSortedIndexCommand(String schemaName, String indexName, boolean ifNotExists, String tableName, boolean unique, List<String> columns, List<CatalogColumnCollation> collations, boolean isCreatedWithTable) throws CatalogValidationException {
        super(schemaName, indexName, ifNotExists, tableName, unique, columns, isCreatedWithTable);
        this.collations = CollectionUtils.copyOrNull(collations);
        this.validate();
    }

    @Override
    protected CatalogIndexDescriptor createDescriptor(int indexId, int tableId, CatalogIndexStatus status) {
        ArrayList<CatalogIndexColumnDescriptor> indexColumnDescriptors = new ArrayList<CatalogIndexColumnDescriptor>(this.columns.size());
        for (int i = 0; i < this.columns.size(); ++i) {
            indexColumnDescriptors.add(new CatalogIndexColumnDescriptor((String)this.columns.get(i), this.collations.get(i)));
        }
        return new CatalogSortedIndexDescriptor(indexId, this.indexName, tableId, this.unique, status, indexColumnDescriptors, this.isCreatedWithTable);
    }

    private void validate() {
        if (CollectionUtils.nullOrEmpty(this.collations)) {
            throw new CatalogValidationException("Collations not specified");
        }
        if (this.collations.size() != this.columns.size()) {
            throw new CatalogValidationException("Columns collations doesn't match number of columns");
        }
    }

    private static class Builder
    implements CreateSortedIndexCommandBuilder {
        private String schemaName;
        private String indexName;
        private boolean ifNotExists;
        private String tableName;
        private List<String> columns;
        private List<CatalogColumnCollation> collations;
        private boolean unique;
        private boolean isCreatedWithTable;

        private Builder() {
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public Builder unique(boolean unique) {
            this.unique = unique;
            return this;
        }

        @Override
        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Override
        public CreateSortedIndexCommandBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateSortedIndexCommandBuilder collations(List<CatalogColumnCollation> collations) {
            this.collations = collations;
            return this;
        }

        @Override
        public CreateSortedIndexCommandBuilder isCreatedWithTable(boolean isCreatedWithTable) {
            this.isCreatedWithTable = isCreatedWithTable;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateSortedIndexCommand(this.schemaName, this.indexName, this.ifNotExists, this.tableName, this.unique, this.columns, this.collations, this.isCreatedWithTable);
        }
    }
}

