/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.ThreadAssertingPartitionTimestampCursor;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.worker.ThreadAssertingCursor;
import org.apache.ignite.internal.worker.ThreadAssertions;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingMvPartitionStorage
implements MvPartitionStorage,
Wrapper {
    private final MvPartitionStorage partitionStorage;

    public ThreadAssertingMvPartitionStorage(MvPartitionStorage partitionStorage) {
        this.partitionStorage = partitionStorage;
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        return this.partitionStorage.runConsistently(closure);
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.flush(trigger);
    }

    @Override
    public long lastAppliedIndex() {
        return this.partitionStorage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.partitionStorage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.partitionStorage.committedGroupConfiguration();
    }

    @Override
    public void committedGroupConfiguration(byte[] config) {
        this.partitionStorage.committedGroupConfiguration(config);
    }

    @Override
    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.read(rowId, timestamp);
    }

    @Override
    @Nullable
    public BinaryRow addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId) throws TxIdMismatchException, StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.addWrite(rowId, row, txId, commitTableId, commitPartitionId);
    }

    @Override
    @Nullable
    public BinaryRow abortWrite(RowId rowId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.abortWrite(rowId);
    }

    @Override
    public void commitWrite(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.commitWrite(rowId, timestamp);
    }

    @Override
    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.addWriteCommitted(rowId, row, commitTimestamp);
    }

    @Override
    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor(this.partitionStorage.scanVersions(rowId));
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingPartitionTimestampCursor(this.partitionStorage.scan(timestamp));
    }

    @Override
    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.closestRowId(lowerBound);
    }

    @Override
    @Nullable
    public GcEntry peek(HybridTimestamp lowWatermark) {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.peek(lowWatermark);
    }

    @Override
    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.vacuum(entry);
    }

    @Override
    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.updateLease(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
    }

    @Override
    public long leaseStartTime() {
        return this.partitionStorage.leaseStartTime();
    }

    @Override
    @Nullable
    public UUID primaryReplicaNodeId() {
        return this.partitionStorage.primaryReplicaNodeId();
    }

    @Override
    @Nullable
    public String primaryReplicaNodeName() {
        return this.partitionStorage.primaryReplicaNodeName();
    }

    @Override
    public long estimatedSize() {
        return this.partitionStorage.estimatedSize();
    }

    @Override
    public void close() {
        this.partitionStorage.close();
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.partitionStorage);
    }
}

