/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.util.TimeoutStrategy;

public class ExponentialBackoffTimeoutStrategy
implements TimeoutStrategy {
    private static final double DEFAULT_BACKOFF_COEFFICIENT = 2.0;
    private static final int DEFAULT_TIMEOUT_MS_MAX = 11000;
    private static final long DEFAULT_ROUNDS_WITHOUT_ADJUSTING = 3L;
    private final int maxTimeout;
    private final long roundsWithoutAdjusting;

    public ExponentialBackoffTimeoutStrategy() {
        this(11000, 3L);
    }

    public ExponentialBackoffTimeoutStrategy(int maxTimeout, long roundsWithoutAdjusting) {
        this.maxTimeout = maxTimeout;
        this.roundsWithoutAdjusting = roundsWithoutAdjusting;
    }

    @Override
    public int nextTimeout(int currentTimeout, long round) {
        if (round <= this.roundsWithoutAdjusting) {
            return currentTimeout;
        }
        return ExponentialBackoffTimeoutStrategy.backoffTimeout(currentTimeout, this.maxTimeout);
    }

    public static int backoffTimeout(int timeout, int maxTimeout) {
        return (int)Math.min((double)timeout * 2.0, (double)maxTimeout);
    }

    public String toString() {
        return S.toString(ExponentialBackoffTimeoutStrategy.class, (Object)this);
    }
}

