/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.lang.IgniteTuple3;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.placementdriver.AssignmentsTracker;
import org.apache.ignite.internal.placementdriver.PlacementDriverManager;
import org.apache.ignite.internal.placementdriver.TopologyTracker;
import org.apache.ignite.internal.placementdriver.leases.Lease;
import org.apache.ignite.internal.placementdriver.leases.LeaseBatch;
import org.apache.ignite.internal.placementdriver.leases.LeaseTracker;
import org.apache.ignite.internal.placementdriver.leases.Leases;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverActorMessage;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverMessageGroup;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverMessagesFactory;
import org.apache.ignite.internal.placementdriver.message.StopLeaseProlongationMessage;
import org.apache.ignite.internal.placementdriver.message.StopLeaseProlongationMessageResponse;
import org.apache.ignite.internal.placementdriver.negotiation.LeaseAgreement;
import org.apache.ignite.internal.placementdriver.negotiation.LeaseNegotiator;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.configuration.ReplicationConfiguration;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class LeaseUpdater {
    private static final int LEASE_UPDATE_STATISTICS_PRINT_ONCE_PER_ITERATIONS = IgniteSystemProperties.getInteger((String)"LEASE_STATISTICS_PRINT_ONCE_PER_ITERATIONS", (int)10);
    private static final PlacementDriverMessagesFactory PLACEMENT_DRIVER_MESSAGES_FACTORY = new PlacementDriverMessagesFactory();
    private static final IgniteLogger LOG = Loggers.forClass(LeaseUpdater.class);
    private static final long UPDATE_LEASE_MS = 500L;
    private final IgniteSpinBusyLock stateChangingLock = new IgniteSpinBusyLock();
    private final AtomicBoolean active = new AtomicBoolean();
    private final ClusterService clusterService;
    private final MetaStorageManager msManager;
    private final AssignmentsTracker assignmentsTracker;
    private final TopologyTracker topologyTracker;
    private final ReplicationConfiguration replicationConfiguration;
    private final LeaseTracker leaseTracker;
    private final ClockService clockService;
    private final Updater updater;
    private IgniteThread updaterThread;
    private LeaseNegotiator leaseNegotiator;
    private final String nodeName;

    LeaseUpdater(String nodeName, ClusterService clusterService, MetaStorageManager msManager, LogicalTopologyService topologyService, LeaseTracker leaseTracker, ClockService clockService, AssignmentsTracker assignmentsTracker, ReplicationConfiguration replicationConfiguration) {
        this.nodeName = nodeName;
        this.clusterService = clusterService;
        this.msManager = msManager;
        this.leaseTracker = leaseTracker;
        this.clockService = clockService;
        this.replicationConfiguration = replicationConfiguration;
        this.assignmentsTracker = assignmentsTracker;
        this.topologyTracker = new TopologyTracker(topologyService);
        this.updater = new Updater();
        clusterService.messagingService().addMessageHandler(PlacementDriverMessageGroup.class, (NetworkMessageHandler)new PlacementDriverActorMessageHandler());
    }

    public void init() {
        this.topologyTracker.startTrack();
    }

    void deInit() {
        this.topologyTracker.stopTrack();
    }

    void activate() {
        if (this.active()) {
            return;
        }
        this.stateChangingLock.block();
        try {
            if (!this.active.compareAndSet(false, true)) {
                return;
            }
            this.leaseNegotiator = new LeaseNegotiator(this.clusterService);
            this.updaterThread = new IgniteThread(this.nodeName, "lease-updater", (Runnable)this.updater, new ThreadOperation[0]);
            this.updaterThread.start();
        }
        finally {
            this.stateChangingLock.unblock();
        }
    }

    void deactivate() {
        if (!this.active()) {
            return;
        }
        this.stateChangingLock.block();
        try {
            if (!this.active.compareAndSet(true, false)) {
                return;
            }
            this.leaseNegotiator = null;
            this.updaterThread.interrupt();
            this.updaterThread = null;
        }
        finally {
            this.stateChangingLock.unblock();
        }
    }

    private CompletableFuture<HybridTimestamp> denyLease(ReplicationGroupId grpId, Lease lease, @Nullable String redirectProposal) {
        Lease deniedLease = lease.denyLease(redirectProposal);
        this.leaseNegotiator.cancelAgreement(grpId);
        Leases leasesCurrent = this.leaseTracker.leasesCurrent();
        Collection<Lease> currentLeases = leasesCurrent.leaseByGroupId().values();
        ByteArray key = PlacementDriverManager.PLACEMENTDRIVER_LEASES_KEY;
        IgniteTuple3<List<Lease>, Boolean, Boolean> renewedLeasesTup = LeaseUpdater.replaceProlongableLeaseInCollection(currentLeases, deniedLease);
        if (!((Boolean)renewedLeasesTup.get3()).booleanValue()) {
            return CompletableFuture.completedFuture(this.clockService.now());
        }
        if (!((Boolean)renewedLeasesTup.get2()).booleanValue()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.msManager.invoke((Condition)Conditions.or((Condition)Conditions.notExists((ByteArray)key), (Condition)Conditions.value((ByteArray)key).eq(leasesCurrent.leasesBytes())), Operations.put((ByteArray)key, (byte[])new LeaseBatch((Collection)renewedLeasesTup.get1()).bytes()), Operations.noop()).thenApply(res -> {
            if (res.booleanValue()) {
                return deniedLease.getExpirationTime();
            }
            return null;
        });
    }

    private static IgniteTuple3<List<Lease>, Boolean, Boolean> replaceProlongableLeaseInCollection(Collection<Lease> leases, Lease newLease) {
        ArrayList<Lease> renewedLeases = new ArrayList<Lease>();
        boolean replaced = false;
        boolean found = false;
        for (Lease ls : leases) {
            if (ls.replicationGroupId().equals((Object)newLease.replicationGroupId())) {
                found = true;
                if (!ls.getStartTime().equals((Object)newLease.getStartTime()) || !ls.isProlongable()) continue;
                renewedLeases.add(newLease);
                replaced = true;
                continue;
            }
            renewedLeases.add(ls);
        }
        return new IgniteTuple3(renewedLeases, (Object)replaced, (Object)found);
    }

    @Nullable
    private ClusterNode nextLeaseHolder(Set<Assignment> stableAssignments, Set<Assignment> pendingAssignments, ReplicationGroupId grpId, @Nullable String proposedConsistentId) {
        ClusterNode primaryCandidate = this.tryToFindCandidateAmongAssignments(stableAssignments, grpId, proposedConsistentId);
        if (primaryCandidate == null) {
            primaryCandidate = this.tryToFindCandidateAmongAssignments(pendingAssignments, grpId, proposedConsistentId);
        }
        return primaryCandidate;
    }

    @Nullable
    private ClusterNode tryToFindCandidateAmongAssignments(Set<Assignment> assignments, ReplicationGroupId grpId, @Nullable String proposedConsistentId) {
        ClusterNode primaryCandidate = null;
        for (Assignment assignment : assignments) {
            ClusterNode candidateNode = this.topologyTracker.nodeByConsistentId(assignment.consistentId());
            if (candidateNode == null) continue;
            if (assignment.consistentId().equals(proposedConsistentId)) {
                primaryCandidate = candidateNode;
                break;
            }
            if (primaryCandidate == null) {
                primaryCandidate = candidateNode;
                continue;
            }
            int candidateHash = Objects.hash(primaryCandidate.name(), grpId);
            int assignmentHash = Objects.hash(assignment.consistentId(), grpId);
            if (candidateHash <= assignmentHash) continue;
            primaryCandidate = candidateNode;
        }
        return primaryCandidate;
    }

    boolean active() {
        return this.active.get();
    }

    private class Updater
    implements Runnable {
        private LeaseStats leaseUpdateStatistics = new LeaseStats();
        private int statisticsLogCounter;

        private Updater() {
        }

        @Override
        public void run() {
            while (LeaseUpdater.this.active() && !Thread.interrupted()) {
                if (!LeaseUpdater.this.stateChangingLock.enterBusy()) continue;
                try {
                    if (LeaseUpdater.this.active()) {
                        this.updateLeaseBatchInternal();
                    }
                }
                catch (Throwable e) {
                    LOG.error("Error occurred when updating the leases.", e);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                }
                finally {
                    LeaseUpdater.this.stateChangingLock.leaveBusy();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Lease updater is interrupted", new Object[0]);
                }
            }
        }

        private void updateLeaseBatchInternal() {
            Lease lease;
            HybridTimestamp currentTime = LeaseUpdater.this.clockService.current();
            this.leaseUpdateStatistics = new LeaseStats();
            long leaseExpirationInterval = (Long)LeaseUpdater.this.replicationConfiguration.leaseExpirationInterval().value();
            long outdatedLeaseThreshold = currentTime.getPhysical() + leaseExpirationInterval / 2L;
            HybridTimestamp newExpirationTimestamp = new HybridTimestamp(currentTime.getPhysical() + leaseExpirationInterval, 0);
            Leases leasesCurrent = LeaseUpdater.this.leaseTracker.leasesCurrent();
            HashMap<ReplicationGroupId, LeaseAgreement> toBeNegotiated = new HashMap<ReplicationGroupId, LeaseAgreement>();
            HashMap<ReplicationGroupId, Lease> renewedLeases = new HashMap<ReplicationGroupId, Lease>(leasesCurrent.leaseByGroupId().size());
            Map<ReplicationGroupId, TokenizedAssignments> tokenizedStableAssignmentsMap = LeaseUpdater.this.assignmentsTracker.stableAssignments();
            Map<ReplicationGroupId, TokenizedAssignments> tokenizedPendingAssignmentsMap = LeaseUpdater.this.assignmentsTracker.pendingAssignments();
            Set groupsAmongCurrentStableAndPendingAssignments = CollectionUtils.union(tokenizedPendingAssignmentsMap.keySet(), tokenizedStableAssignmentsMap.keySet());
            HashMap<ReplicationGroupId, Pair> aggregatedStableAndPendingAssignmentsByGroups = new HashMap<ReplicationGroupId, Pair>();
            for (ReplicationGroupId grpId : groupsAmongCurrentStableAndPendingAssignments) {
                Set<Assignment> stables = this.getAssignmentsFromTokenizedAssignmentsMap(grpId, tokenizedStableAssignmentsMap);
                Set<Assignment> pendings = this.getAssignmentsFromTokenizedAssignmentsMap(grpId, tokenizedPendingAssignmentsMap);
                aggregatedStableAndPendingAssignmentsByGroups.put(grpId, new Pair(stables, pendings));
            }
            int currentStableAssignmentsSize = tokenizedStableAssignmentsMap.size();
            int currentPendingAssignmentsSize = tokenizedPendingAssignmentsMap.size();
            int activeLeasesCount = 0;
            HashSet<ReplicationGroupId> prolongableLeaseGroupIds = new HashSet<ReplicationGroupId>();
            for (Map.Entry entry : aggregatedStableAndPendingAssignmentsByGroups.entrySet()) {
                boolean canBeProlonged;
                ReplicationGroupId grpId = (ReplicationGroupId)entry.getKey();
                Set stableAssignments = (Set)((Pair)entry.getValue()).getFirst();
                Set pendingAssignments = (Set)((Pair)entry.getValue()).getSecond();
                lease = Objects.requireNonNullElse(leasesCurrent.leaseByGroupId().get(grpId), Lease.emptyLease(grpId));
                if (lease.isAccepted() && !this.isLeaseOutdated(lease)) {
                    ++activeLeasesCount;
                }
                if (!lease.isAccepted()) {
                    LeaseAgreement agreement = LeaseUpdater.this.leaseNegotiator.getAndRemoveIfReady(grpId);
                    agreement.checkValid(grpId, LeaseUpdater.this.topologyTracker.currentTopologySnapshot(), CollectionUtils.union((Set)stableAssignments, (Set)pendingAssignments));
                    if (lease.isProlongable() && agreement.isAccepted()) {
                        Lease negotiatedLease = agreement.getLease();
                        assert (negotiatedLease.getStartTime().longValue() >= lease.getStartTime().longValue()) : IgniteStringFormatter.format((String)"Can't publish the lease that was not negotiated [groupId={}, startTime={}, agreementLeaseStartTime={}].", (Object[])new Object[]{grpId, lease.getStartTime(), agreement.getLease().getStartTime()});
                        this.publishLease(grpId, negotiatedLease, renewedLeases, leaseExpirationInterval);
                        continue;
                    }
                    if (!lease.isProlongable() || agreement.isDeclined()) {
                        this.chooseCandidateAndCreateNewLease(grpId, lease, agreement, stableAssignments, pendingAssignments, renewedLeases, toBeNegotiated);
                        continue;
                    }
                }
                String proposedLeaseholder = lease.isProlongable() ? lease.getLeaseholder() : lease.proposedCandidate();
                ClusterNode candidate = LeaseUpdater.this.nextLeaseHolder(stableAssignments, pendingAssignments, grpId, proposedLeaseholder);
                boolean bl = canBeProlonged = lease.isAccepted() && lease.isProlongable() && candidate != null && candidate.id().equals(lease.getLeaseholderId());
                if (lease.getExpirationTime().getPhysical() < outdatedLeaseThreshold) {
                    if (candidate == null) {
                        this.leaseUpdateStatistics.onLeaseWithoutCandidate();
                        continue;
                    }
                    if (this.isLeaseOutdated(lease)) {
                        Lease newLease = this.writeNewLease(grpId, candidate, renewedLeases);
                        boolean force = !lease.isProlongable() && lease.proposedCandidate() != null;
                        toBeNegotiated.put(grpId, new LeaseAgreement(newLease, force));
                        continue;
                    }
                    if (!canBeProlonged) continue;
                    renewedLeases.put(grpId, this.prolongLease(lease, newExpirationTimestamp));
                    continue;
                }
                if (!canBeProlonged) continue;
                prolongableLeaseGroupIds.add(grpId);
            }
            ByteArray key = PlacementDriverManager.PLACEMENTDRIVER_LEASES_KEY;
            if (this.shouldLogLeaseStatistics()) {
                LOG.info("Leases updated (printed once per {} iteration(s)): [inCurrentIteration={}, active={}, currentStableAssignmentsSize={}, currentPendingAssignmentsSize={}].", new Object[]{LEASE_UPDATE_STATISTICS_PRINT_ONCE_PER_ITERATIONS, this.leaseUpdateStatistics, activeLeasesCount, currentStableAssignmentsSize, currentPendingAssignmentsSize});
            }
            boolean emptyAssignments = aggregatedStableAndPendingAssignmentsByGroups.isEmpty();
            if (renewedLeases.isEmpty() && (!emptyAssignments || leasesCurrent.leaseByGroupId().isEmpty())) {
                LOG.debug("No leases to update found.", new Object[0]);
                return;
            }
            leasesCurrent.leaseByGroupId().forEach(renewedLeases::putIfAbsent);
            Iterator iter = renewedLeases.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ReplicationGroupId groupId = (ReplicationGroupId)entry.getKey();
                lease = (Lease)entry.getValue();
                if (LeaseUpdater.this.clockService.before(lease.getExpirationTime(), currentTime) && !groupsAmongCurrentStableAndPendingAssignments.contains(groupId)) {
                    iter.remove();
                    continue;
                }
                if (!prolongableLeaseGroupIds.contains(groupId)) continue;
                entry.setValue(this.prolongLease(lease, newExpirationTimestamp));
            }
            byte[] renewedValue = new LeaseBatch(renewedLeases.values()).bytes();
            LeaseUpdater.this.msManager.invoke((Condition)Conditions.or((Condition)Conditions.notExists((ByteArray)key), (Condition)Conditions.value((ByteArray)key).eq(leasesCurrent.leasesBytes())), Operations.put((ByteArray)key, (byte[])renewedValue), Operations.noop()).whenComplete((success, e) -> {
                if (e != null) {
                    if (!(ExceptionUtils.unwrapCause((Throwable)e) instanceof NodeStoppingException)) {
                        LOG.error("Lease update invocation failed", e);
                    }
                    return;
                }
                if (!success.booleanValue()) {
                    LOG.warn("Lease update invocation failed because of outdated lease data on this node.", new Object[0]);
                    return;
                }
                for (Map.Entry entry : toBeNegotiated.entrySet()) {
                    LeaseUpdater.this.leaseNegotiator.negotiate((LeaseAgreement)entry.getValue());
                }
            });
        }

        private void chooseCandidateAndCreateNewLease(ReplicationGroupId grpId, Lease existingLease, LeaseAgreement agreement, Set<Assignment> stableAssignments, Set<Assignment> pendingAssignments, Map<ReplicationGroupId, Lease> renewedLeases, Map<ReplicationGroupId, LeaseAgreement> toBeNegotiated) {
            ClusterNode candidate;
            String proposedCandidate = null;
            if (agreement.isDeclined()) {
                proposedCandidate = agreement.getRedirectTo();
            }
            if (proposedCandidate == null) {
                String string = proposedCandidate = existingLease.isProlongable() ? existingLease.getLeaseholder() : existingLease.proposedCandidate();
            }
            if ((candidate = LeaseUpdater.this.nextLeaseHolder(stableAssignments, pendingAssignments, grpId, proposedCandidate)) == null) {
                this.leaseUpdateStatistics.onLeaseWithoutCandidate();
                return;
            }
            Lease newLease = this.writeNewLease(grpId, candidate, renewedLeases);
            boolean force = Objects.equals(existingLease.getLeaseholder(), candidate.name()) && !agreement.isCancelled();
            toBeNegotiated.put(grpId, new LeaseAgreement(newLease, force));
        }

        private Lease writeNewLease(ReplicationGroupId grpId, ClusterNode candidate, Map<ReplicationGroupId, Lease> renewedLeases) {
            HybridTimestamp startTs = LeaseUpdater.this.clockService.now();
            long interval = (Long)LeaseUpdater.this.replicationConfiguration.leaseAgreementAcceptanceTimeLimit().value();
            HybridTimestamp expirationTs = new HybridTimestamp(startTs.getPhysical() + interval, 0);
            Lease renewedLease = new Lease(candidate.name(), candidate.id(), startTs, expirationTs, grpId);
            renewedLeases.put(grpId, renewedLease);
            this.leaseUpdateStatistics.onLeaseCreate();
            return renewedLease;
        }

        private Lease prolongLease(Lease lease, HybridTimestamp newExpirationTimestamp) {
            this.leaseUpdateStatistics.onLeaseProlong();
            return lease.prolongLease(newExpirationTimestamp);
        }

        private void publishLease(ReplicationGroupId grpId, Lease lease, Map<ReplicationGroupId, Lease> renewedLeases, long leaseExpirationInterval) {
            HybridTimestamp newTs = new HybridTimestamp(LeaseUpdater.this.clockService.now().getPhysical() + leaseExpirationInterval, 0);
            Lease renewedLease = lease.acceptLease(newTs);
            renewedLeases.put(grpId, renewedLease);
            this.leaseUpdateStatistics.onLeasePublish();
        }

        private boolean isLeaseOutdated(Lease lease) {
            HybridTimestamp now = LeaseUpdater.this.clockService.now();
            return LeaseUpdater.this.clockService.after(now, lease.getExpirationTime());
        }

        private boolean shouldLogLeaseStatistics() {
            boolean result;
            if (LEASE_UPDATE_STATISTICS_PRINT_ONCE_PER_ITERATIONS < 0) {
                return false;
            }
            boolean bl = result = ++this.statisticsLogCounter > LEASE_UPDATE_STATISTICS_PRINT_ONCE_PER_ITERATIONS;
            if (result) {
                this.statisticsLogCounter = 0;
            }
            return result;
        }

        private Set<Assignment> getAssignmentsFromTokenizedAssignmentsMap(ReplicationGroupId grpId, Map<ReplicationGroupId, TokenizedAssignments> tokenizedAssignmentsMap) {
            TokenizedAssignments pendingTokenizedAssignments = tokenizedAssignmentsMap.get(grpId);
            return pendingTokenizedAssignments == null ? new HashSet() : pendingTokenizedAssignments.nodes();
        }
    }

    private class PlacementDriverActorMessageHandler
    implements NetworkMessageHandler {
        private PlacementDriverActorMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceived(NetworkMessage msg0, ClusterNode sender, @Nullable Long correlationId) {
            if (!(msg0 instanceof PlacementDriverActorMessage)) {
                return;
            }
            PlacementDriverActorMessage msg = (PlacementDriverActorMessage)msg0;
            if (!LeaseUpdater.this.active() || !LeaseUpdater.this.stateChangingLock.enterBusy()) {
                return;
            }
            try {
                this.processMessageInternal(sender.name(), msg, correlationId);
            }
            finally {
                LeaseUpdater.this.stateChangingLock.leaveBusy();
            }
        }

        private void processMessageInternal(String sender, PlacementDriverActorMessage msg, @Nullable Long correlationId) {
            ReplicationGroupId grpId = msg.groupId();
            Lease lease = LeaseUpdater.this.leaseTracker.getLease(grpId);
            if (msg instanceof StopLeaseProlongationMessage) {
                if (sender.equals(lease.getLeaseholder())) {
                    StopLeaseProlongationMessage stopLeaseProlongationMessage = (StopLeaseProlongationMessage)msg;
                    LeaseUpdater.this.denyLease(grpId, lease, stopLeaseProlongationMessage.redirectProposal()).whenComplete((deniedLeaseExpTime, th) -> {
                        if (th != null) {
                            LOG.warn("Prolongation denial failed due to exception [groupId={}]", th, new Object[]{grpId});
                        } else {
                            LOG.info("Stop lease prolongation message was handled [groupId={}, leaseStartTime={}, leaseExpirationTime={}, sender={}, denied={}]", new Object[]{grpId, lease.getStartTime(), deniedLeaseExpTime, sender, deniedLeaseExpTime != null});
                        }
                        if (correlationId != null) {
                            long deniedLeaseExpTimeLong = deniedLeaseExpTime == null ? 0L : deniedLeaseExpTime.longValue();
                            StopLeaseProlongationMessageResponse response = PLACEMENT_DRIVER_MESSAGES_FACTORY.stopLeaseProlongationMessageResponse().deniedLeaseExpirationTimeLong(deniedLeaseExpTimeLong).build();
                            LeaseUpdater.this.clusterService.messagingService().respond(sender, (NetworkMessage)response, correlationId.longValue());
                        }
                    });
                }
            } else {
                LOG.warn("Unknown message type [msg={}]", new Object[]{msg.getClass().getSimpleName()});
            }
        }
    }

    private static class LeaseStats {
        @IgniteToStringInclude
        int leasesCreated;
        @IgniteToStringInclude
        int leasesPublished;
        @IgniteToStringInclude
        int leasesProlonged;
        @IgniteToStringInclude
        int leasesWithoutCandidates;

        private LeaseStats() {
        }

        private void onLeaseCreate() {
            ++this.leasesCreated;
        }

        private void onLeasePublish() {
            ++this.leasesPublished;
        }

        private void onLeaseProlong() {
            ++this.leasesProlonged;
        }

        private void onLeaseWithoutCandidate() {
            ++this.leasesWithoutCandidates;
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }
}

