/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class SnapshotEntry
implements UpdateLogEvent {
    private final int version;
    private final long activationTime;
    private final int objectIdGenState;
    private final CatalogZoneDescriptor[] zones;
    private final CatalogSchemaDescriptor[] schemas;
    @Nullable
    private final Integer defaultZoneId;

    public SnapshotEntry(Catalog catalog) {
        this(catalog.version(), catalog.time(), catalog.objectIdGenState(), (CatalogZoneDescriptor[])catalog.zones().toArray(CatalogZoneDescriptor[]::new), (CatalogSchemaDescriptor[])catalog.schemas().toArray(CatalogSchemaDescriptor[]::new), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    SnapshotEntry(int version, long activationTime, int objectIdGenState, CatalogZoneDescriptor[] zones, CatalogSchemaDescriptor[] schemas, @Nullable Integer defaultZoneId) {
        this.version = version;
        this.activationTime = activationTime;
        this.objectIdGenState = objectIdGenState;
        this.zones = zones;
        this.schemas = schemas;
        this.defaultZoneId = defaultZoneId;
    }

    public int version() {
        return this.version;
    }

    public long activationTime() {
        return this.activationTime;
    }

    public int objectIdGenState() {
        return this.objectIdGenState;
    }

    public CatalogZoneDescriptor[] zones() {
        return this.zones;
    }

    public CatalogSchemaDescriptor[] schemas() {
        return this.schemas;
    }

    @Nullable
    public Integer defaultZoneId() {
        return this.defaultZoneId;
    }

    public Catalog snapshot() {
        return new Catalog(this.version, this.activationTime, this.objectIdGenState, List.of(this.zones), List.of(this.schemas), this.defaultZoneId);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.SNAPSHOT.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotEntry that = (SnapshotEntry)o;
        return this.version == that.version && this.activationTime == that.activationTime && this.objectIdGenState == that.objectIdGenState && Arrays.equals(this.zones, that.zones) && Arrays.equals(this.schemas, that.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

