/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommandV2;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommandV2Builder;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class UpdateCommandV2Deserializer
implements MessageDeserializer<UpdateCommandV2> {
    private final UpdateCommandV2Builder msg;

    UpdateCommandV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.updateCommandV2();
    }

    public Class<UpdateCommandV2> klass() {
        return UpdateCommandV2.class;
    }

    public UpdateCommandV2 getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readBoxedLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaseStartTime((Long)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = (TimedBinaryRowMessage)reader.readMessage("messageRowToUpdate");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.messageRowToUpdate((TimedBinaryRowMessage)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readUuid("rowUuid");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.rowUuid((UUID)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 7: {
                UUID tmp = (ReplicationGroupIdMessage)reader.readMessage("tablePartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 8: {
                UUID tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txCoordinatorId(tmp);
                reader.incrementState();
            }
            case 9: {
                UUID tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UpdateCommandV2.class);
    }
}

