/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.messaging;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.messaging.ComputeMessaging;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class RemoteJobExecution
implements CancellableJobExecution<ComputeJobDataHolder> {
    private final InternalClusterNode remoteNode;
    private final ClusterNode publicRemoteNode;
    private final UUID jobId;
    private final CompletableFuture<ComputeJobDataHolder> resultFuture;
    private final InFlightFutures inFlightFutures;
    private final ComputeMessaging messaging;

    public RemoteJobExecution(InternalClusterNode remoteNode, UUID jobId, InFlightFutures inFlightFutures, ComputeMessaging messaging) {
        this.remoteNode = remoteNode;
        this.jobId = jobId;
        this.resultFuture = inFlightFutures.registerFuture(messaging.remoteJobResultRequestAsync(remoteNode, jobId));
        this.inFlightFutures = inFlightFutures;
        this.messaging = messaging;
        this.publicRemoteNode = remoteNode.toPublicNode();
    }

    public CompletableFuture<ComputeJobDataHolder> resultAsync() {
        return this.resultFuture;
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.inFlightFutures.registerFuture(this.messaging.remoteStateAsync(this.remoteNode, this.jobId));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        return this.inFlightFutures.registerFuture(this.messaging.remoteCancelAsync(this.remoteNode, this.jobId));
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.inFlightFutures.registerFuture(this.messaging.remoteChangePriorityAsync(this.remoteNode, this.jobId, newPriority));
    }

    public ClusterNode node() {
        return this.publicRemoteNode;
    }
}

