/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.tree;

import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.jetbrains.annotations.Nullable;

public abstract class InnerNode
implements TraversableTreeNode,
ConstructableTreeNode,
Cloneable {
    public static final String INTERNAL_ID = "<internal_id>";
    public static final String INJECTED_NAME = "<injected_name>";
    @Nullable
    private UUID internalId;
    private boolean immutable = false;

    @Nullable
    public final UUID internalId() {
        return this.internalId;
    }

    public final void internalId(UUID internalId) {
        this.assertMutability();
        this.internalId = internalId;
    }

    @Override
    public final <T> T accept(Field field, String key, ConfigurationVisitor<T> visitor) {
        return visitor.visitInnerNode(field, key, this);
    }

    public abstract <T> void traverseChildren(ConfigurationVisitor<T> var1, boolean var2);

    public abstract <T> T traverseChild(String var1, ConfigurationVisitor<T> var2, boolean var3) throws NoSuchElementException;

    @Override
    public abstract void construct(String var1, ConfigurationSource var2, boolean var3) throws NoSuchElementException;

    public abstract void constructDefault(String var1) throws NoSuchElementException;

    public abstract Class<?> schemaType();

    @Override
    public InnerNode copy() {
        try {
            InnerNode clone = (InnerNode)this.clone();
            clone.immutable = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public final void assertMutability() {
        if (this.immutable) {
            throw new AssertionError((Object)"Mutating immutable configuration");
        }
    }

    @Override
    public boolean makeImmutable() {
        boolean updated = !this.immutable;
        this.immutable = true;
        return updated;
    }

    public <NODET> NODET specificNode() {
        return (NODET)this;
    }

    public String getInjectedNameFieldValue() {
        return null;
    }

    public void setInjectedNameFieldValue(String value) {
        this.assertMutability();
    }

    public Class<?> @Nullable [] extensionSchemaTypes() {
        return null;
    }

    public boolean isPolymorphic() {
        return false;
    }

    public boolean extendsAbstractConfiguration() {
        return false;
    }
}

