/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.reactor.http.client.BridgedReactorStreamingHttpClient;
import io.micronaut.reactor.http.client.ReactorHttpClient;
import java.net.URL;
import java.util.Map;
import reactor.core.publisher.Flux;

public interface ReactorStreamingHttpClient
extends ReactorHttpClient,
StreamingHttpClient {
    public <I> Flux<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> var1);

    public <I> Flux<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> var1);

    public <I> Flux<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> var1);

    public <I, O> Flux<O> jsonStream(@NonNull HttpRequest<I> var1, @NonNull Argument<O> var2);

    public <I, O> Flux<O> jsonStream(@NonNull HttpRequest<I> var1, @NonNull Class<O> var2);

    @NonNull
    public static ReactorStreamingHttpClient create(@Nullable URL url) {
        return new BridgedReactorStreamingHttpClient(StreamingHttpClient.create((URL)url));
    }

    @NonNull
    public static ReactorStreamingHttpClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return new BridgedReactorStreamingHttpClient(StreamingHttpClient.create((URL)url, (HttpClientConfiguration)configuration));
    }
}

