/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.control;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.control.FlowControl;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public class TryCatch
implements FlowControl {
    private final String comment;
    private final BytecodeNode tryNode;
    private final BytecodeNode catchNode;
    private final String exceptionName;

    public TryCatch(BytecodeNode tryNode, BytecodeNode catchNode, ParameterizedType exceptionType) {
        this(null, tryNode, catchNode, exceptionType);
    }

    public TryCatch(String comment, BytecodeNode tryNode, BytecodeNode catchNode, ParameterizedType exceptionType) {
        this.comment = comment;
        this.tryNode = Objects.requireNonNull(tryNode, "tryNode is null");
        this.catchNode = Objects.requireNonNull(catchNode, "catchNode is null");
        this.exceptionName = exceptionType != null ? exceptionType.getClassName() : null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public BytecodeNode getTryNode() {
        return this.tryNode;
    }

    public BytecodeNode getCatchNode() {
        return this.catchNode;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        LabelNode tryStart = new LabelNode("tryStart");
        LabelNode tryEnd = new LabelNode("tryEnd");
        LabelNode handler = new LabelNode("handler");
        LabelNode done = new LabelNode("done");
        BytecodeBlock block = new BytecodeBlock();
        block.visitLabel(tryStart).append(this.tryNode).visitLabel(tryEnd).gotoLabel(done);
        block.visitLabel(handler).append(this.catchNode);
        block.visitLabel(done);
        block.accept(visitor, generationContext);
        visitor.visitTryCatchBlock(tryStart.getLabel(), tryEnd.getLabel(), handler.getLabel(), this.exceptionName);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of(this.tryNode, this.catchNode);
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitTryCatch(parent, this);
    }
}

