/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.commands.AbstractCreateIndexCommand;
import org.apache.ignite3.internal.catalog.commands.CreateHashIndexCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;

public class CreateHashIndexCommand
extends AbstractCreateIndexCommand {
    public static CreateHashIndexCommandBuilder builder() {
        return new Builder();
    }

    private CreateHashIndexCommand(String schemaName, String indexName, boolean ifNotExists, String tableName, boolean unique, List<String> columns) throws CatalogValidationException {
        super(schemaName, indexName, ifNotExists, tableName, unique, columns);
    }

    @Override
    protected CatalogIndexDescriptor createDescriptor(int indexId, int tableId, CatalogIndexStatus status, boolean createdWithTable) {
        return new CatalogHashIndexDescriptor(indexId, this.indexName, tableId, this.unique, status, this.columns, createdWithTable);
    }

    private static class Builder
    implements CreateHashIndexCommandBuilder {
        private String schemaName;
        private String indexName;
        private boolean ifNotExists;
        private String tableName;
        private List<String> columns;
        private boolean unique;

        private Builder() {
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public Builder unique(boolean unique) {
            this.unique = unique;
            return this;
        }

        @Override
        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Override
        public CreateHashIndexCommandBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateHashIndexCommand(this.schemaName, this.indexName, this.ifNotExists, this.tableName, this.unique, this.columns);
        }
    }
}

