/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.checkpoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite3.internal.metrics.Metric;
import org.apache.ignite3.internal.metrics.MetricSet;
import org.apache.ignite3.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class CheckpointMetricSource
implements MetricSource {
    private final String name;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();
    private boolean enabled;

    public CheckpointMetricSource(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String group() {
        return "storage";
    }

    synchronized <T extends Metric> T addMetric(T metric) {
        assert (!this.enabled) : "Cannot add metrics when source is enabled";
        this.metrics.put(metric.name(), metric);
        return metric;
    }

    @Override
    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        this.enabled = true;
        return new MetricSet(this.name, this.description(), this.group(), Map.copyOf(this.metrics));
    }

    @Override
    public synchronized void disable() {
        this.enabled = false;
    }

    @Override
    public synchronized boolean enabled() {
        return this.enabled;
    }
}

