/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.kill;

import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite3.internal.sql.engine.api.kill.KillHandlerRegistry;
import org.apache.ignite3.internal.sql.engine.api.kill.OperationKillHandler;
import org.apache.ignite3.internal.sql.engine.exec.kill.KillCommand;
import org.apache.ignite3.internal.sql.engine.exec.kill.LocalToClusterKillHandlerWrapper;
import org.apache.ignite3.internal.sql.engine.message.CancelOperationRequest;
import org.apache.ignite3.internal.sql.engine.message.CancelOperationResponse;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessageGroup;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class KillCommandHandler
implements KillHandlerRegistry {
    private static final SqlQueryMessagesFactory FACTORY = new SqlQueryMessagesFactory();
    private final EnumMap<CancellableOperationType, OperationKillHandler> localHandlers = new EnumMap(CancellableOperationType.class);
    private final EnumMap<CancellableOperationType, OperationKillHandler> clusterHandlers = new EnumMap(CancellableOperationType.class);
    private final String localNodeName;
    private final LogicalTopologyService logicalTopologyService;
    private final MessagingService messageService;

    public KillCommandHandler(String localNodeName, LogicalTopologyService logicalTopologyService, MessagingService messageService) {
        this.localNodeName = localNodeName;
        this.logicalTopologyService = logicalTopologyService;
        this.messageService = messageService;
        messageService.addMessageHandler(SqlQueryMessageGroup.class, this::onMessage);
    }

    @Override
    public void register(OperationKillHandler handler) {
        OperationKillHandler clusterWideHandler;
        Objects.requireNonNull(handler, "handler");
        Objects.requireNonNull(handler.type(), "handler type cannot be null");
        if (handler.local()) {
            this.localHandlers.putIfAbsent(handler.type(), handler);
            clusterWideHandler = new LocalToClusterKillHandlerWrapper(handler, this.localNodeName, this.logicalTopologyService, this.messageService);
        } else {
            clusterWideHandler = handler;
        }
        OperationKillHandler prevHandler = this.clusterHandlers.putIfAbsent(handler.type(), clusterWideHandler);
        if (prevHandler != null) {
            throw new IllegalArgumentException("A handler for the specified type has already been registered [type=" + handler.type() + ", prev=" + handler + "].");
        }
    }

    @Override
    public OperationKillHandler handler(CancellableOperationType type) {
        return this.handlerOrThrow(type, false);
    }

    public CompletableFuture<Boolean> handle(KillCommand cmd) {
        OperationKillHandler handler = this.handlerOrThrow(cmd.type(), false);
        CompletableFuture<Boolean> killFut = KillCommandHandler.invokeCancel(handler, cmd.operationId());
        if (cmd.noWait()) {
            return killFut.isCompletedExceptionally() ? killFut : CompletableFutures.trueCompletedFuture();
        }
        return killFut;
    }

    OperationKillHandler handlerOrThrow(CancellableOperationType type, boolean local) {
        Objects.requireNonNull(type, "type");
        EnumMap<CancellableOperationType, OperationKillHandler> handlers = local ? this.localHandlers : this.clusterHandlers;
        OperationKillHandler handler = handlers.get((Object)type);
        if (handler == null) {
            throw new IllegalArgumentException("No handler is registered for the specified type [type=" + type + ", local=" + local + "].");
        }
        return handler;
    }

    private void onMessage(NetworkMessage networkMessage, InternalClusterNode clusterNode, @Nullable Long correlationId) {
        if (networkMessage instanceof CancelOperationRequest) {
            assert (correlationId != null);
            try {
                CancelOperationRequest request = (CancelOperationRequest)networkMessage;
                CancellableOperationType type = CancellableOperationType.fromId(request.typeId());
                OperationKillHandler handler = this.handlerOrThrow(type, true);
                String operationId = request.operationId();
                KillCommandHandler.invokeCancel(handler, operationId).whenComplete((result, throwable) -> {
                    CancelOperationResponse response = throwable != null ? KillCommandHandler.errorResponse(throwable) : FACTORY.cancelOperationResponse().result((Boolean)result).build();
                    this.messageService.respond(clusterNode, (NetworkMessage)response, (long)correlationId);
                });
            }
            catch (Throwable t) {
                this.messageService.respond(clusterNode, (NetworkMessage)KillCommandHandler.errorResponse(t), (long)correlationId);
            }
        }
    }

    private static CompletableFuture<Boolean> invokeCancel(OperationKillHandler handler, String operationId) {
        try {
            return handler.cancelAsync(operationId);
        }
        catch (IllegalArgumentException e) {
            String errMessage = IgniteStringFormatter.format("Invalid operation ID format [operationId={}, type={}].", new Object[]{operationId, handler.type()});
            return CompletableFuture.failedFuture(new SqlException(ErrorGroups.Sql.RUNTIME_ERR, errMessage, (Throwable)e));
        }
    }

    private static CancelOperationResponse errorResponse(Throwable t) {
        return FACTORY.cancelOperationResponse().error(t).build();
    }
}

