/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.index;

import java.util.HashSet;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;

public final class MetaIndexStatus
extends Enum<MetaIndexStatus> {
    public static final /* enum */ MetaIndexStatus REGISTERED = new MetaIndexStatus(0);
    public static final /* enum */ MetaIndexStatus BUILDING = new MetaIndexStatus(1);
    public static final /* enum */ MetaIndexStatus AVAILABLE = new MetaIndexStatus(2);
    public static final /* enum */ MetaIndexStatus STOPPING = new MetaIndexStatus(3);
    public static final /* enum */ MetaIndexStatus REMOVED = new MetaIndexStatus(4);
    public static final /* enum */ MetaIndexStatus READ_ONLY = new MetaIndexStatus(5);
    private final int code;
    private static final MetaIndexStatus[] VALUES_INDEXED_BY_CODE;
    private static final /* synthetic */ MetaIndexStatus[] $VALUES;

    public static MetaIndexStatus[] values() {
        return (MetaIndexStatus[])$VALUES.clone();
    }

    public static MetaIndexStatus valueOf(String name) {
        return Enum.valueOf(MetaIndexStatus.class, name);
    }

    private MetaIndexStatus(int code) {
        this.code = code;
    }

    static MetaIndexStatus findByCode(int code) {
        MetaIndexStatus status = VALUES_INDEXED_BY_CODE[code];
        if (status == null) {
            throw new IllegalArgumentException("Unknown code [" + code + "]");
        }
        return status;
    }

    public int code() {
        return this.code;
    }

    public static MetaIndexStatus convert(CatalogIndexStatus catalogIndexStatus) {
        switch (catalogIndexStatus) {
            case REGISTERED: {
                return REGISTERED;
            }
            case BUILDING: {
                return BUILDING;
            }
            case AVAILABLE: {
                return AVAILABLE;
            }
            case STOPPING: {
                return STOPPING;
            }
        }
        throw new AssertionError((Object)("Unknown status: " + catalogIndexStatus));
    }

    static MetaIndexStatus statusOnRemoveIndex(MetaIndexStatus previousStatus) {
        switch (previousStatus) {
            case REGISTERED: 
            case BUILDING: {
                return REMOVED;
            }
            case AVAILABLE: 
            case STOPPING: {
                return READ_ONLY;
            }
        }
        throw new AssertionError((Object)("Unknown status: " + previousStatus));
    }

    private static /* synthetic */ MetaIndexStatus[] $values() {
        return new MetaIndexStatus[]{REGISTERED, BUILDING, AVAILABLE, STOPPING, REMOVED, READ_ONLY};
    }

    static {
        $VALUES = MetaIndexStatus.$values();
        int maxCode = -1;
        HashSet<Integer> seenCodes = new HashSet<Integer>();
        for (MetaIndexStatus status : MetaIndexStatus.values()) {
            assert (status.code >= 0) : status + " has a negative code";
            maxCode = Math.max(maxCode, status.code);
            boolean added = seenCodes.add(status.code);
            assert (added) : "Duplicate status code for: " + status;
        }
        VALUES_INDEXED_BY_CODE = new MetaIndexStatus[maxCode + 1];
        MetaIndexStatus[] metaIndexStatusArray = MetaIndexStatus.values();
        int n = metaIndexStatusArray.length;
        for (int i = 0; i < n; ++i) {
            MetaIndexStatus status;
            MetaIndexStatus.VALUES_INDEXED_BY_CODE[status.code] = status = metaIndexStatusArray[i];
        }
    }
}

