/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.error;

import java.util.HashMap;
import java.util.Map;

public enum RaftError {
    UNKNOWN(-1),
    SUCCESS(0),
    ERAFTTIMEDOUT(10001),
    ESTATEMACHINE(10002),
    ECATCHUP(10003),
    ELEADERREMOVED(10004),
    ESETPEER(10005),
    ENODESHUTDOWN(10006),
    EHIGHERTERMREQUEST(10007),
    EHIGHERTERMRESPONSE(10008),
    EBADNODE(10009),
    EVOTEFORCANDIDATE(10010),
    ENEWLEADER(10011),
    ELEADERCONFLICT(10012),
    ETRANSFERLEADERSHIP(10013),
    ELOGDELETED(10014),
    ENOMOREUSERLOG(10015),
    EREQUEST(1000),
    ESTOP(1001),
    EAGAIN(1002),
    EINTR(1003),
    EINTERNAL(1004),
    ECANCELED(1005),
    EHOSTDOWN(1006),
    ESHUTDOWN(1007),
    EPERM(1008),
    EBUSY(1009),
    ETIMEDOUT(1010),
    ESTALE(1011),
    ENOENT(1012),
    EEXISTS(1013),
    EIO(1014),
    EINVAL(1015),
    EACCES(1016);

    private static final Map<Integer, RaftError> RAFT_ERROR_MAP;
    private final int value;

    public final int getNumber() {
        return this.value;
    }

    public static RaftError forNumber(int value) {
        return RAFT_ERROR_MAP.getOrDefault(value, UNKNOWN);
    }

    public static String describeCode(int code) {
        RaftError e = RaftError.forNumber(code);
        return e != null ? e.name() : "<Unknown:" + code + ">";
    }

    private RaftError(int value) {
        this.value = value;
    }

    static {
        RAFT_ERROR_MAP = new HashMap<Integer, RaftError>();
        for (RaftError error : RaftError.values()) {
            RAFT_ERROR_MAP.put(error.getNumber(), error);
        }
    }
}

