/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.affinity.rendezvous;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteBiPredicate;

public class ClusterNodeAttributeAffinityBackupFilter
implements IgniteBiPredicate<ClusterNode, List<ClusterNode>> {
    private static final long serialVersionUID = 1L;
    private final String[] attrNames;

    public ClusterNodeAttributeAffinityBackupFilter(String ... attrNames) {
        A.ensure(attrNames.length > 0, "attributeNames.length > 0");
        this.attrNames = (String[])attrNames.clone();
    }

    @Override
    public boolean apply(ClusterNode candidate, List<ClusterNode> previouslySelected) {
        for (ClusterNode node : previouslySelected) {
            boolean match = true;
            for (String attr : this.attrNames) {
                if (Objects.equals(candidate.attribute(attr), node.attribute(attr))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return false;
        }
        return true;
    }

    public String[] getAttributeNames() {
        return (String[])this.attrNames.clone();
    }
}

