/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfoBean;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheMessage
implements Message {
    private static final long serialVersionUID = 0L;
    public static final int MAX_CACHE_MSG_LOOKUP_INDEX = 7;
    public static final String CACHE_MSG_INDEX_FIELD_NAME = "CACHE_MSG_IDX";
    private static final AtomicInteger msgIdx = new AtomicInteger();
    private static final long NULL_MSG_ID = -1L;
    private long msgId = -1L;
    @GridToStringInclude
    private GridDeploymentInfoBean depInfo;
    @GridToStringInclude
    @Nullable
    private AffinityTopologyVersion lastAffChangedTopVer;
    @GridDirectTransient
    protected boolean addDepInfo;
    @GridDirectTransient
    protected boolean forceAddDepInfo;
    @GridDirectTransient
    private IgniteCheckedException err;
    @GridDirectTransient
    private boolean skipPrepare;

    public abstract int handlerId();

    public abstract boolean cacheGroupMessage();

    @Nullable
    public Throwable error() {
        return null;
    }

    public static int nextIndexId() {
        return msgIdx.getAndIncrement();
    }

    public boolean partitionExchangeMessage() {
        return false;
    }

    public boolean ignoreClassErrors() {
        return false;
    }

    public int lookupIndex() {
        return -1;
    }

    public int partition() {
        return -1;
    }

    public void onClassError(IgniteCheckedException err) {
        this.err = err;
    }

    public IgniteCheckedException classError() {
        return this.err;
    }

    public long messageId() {
        return this.msgId;
    }

    void messageId(long msgId) {
        this.msgId = msgId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return AffinityTopologyVersion.NONE;
    }

    public AffinityTopologyVersion lastAffinityChangedTopologyVersion() {
        if (this.lastAffChangedTopVer == null || this.lastAffChangedTopVer.topologyVersion() <= 0L) {
            return this.topologyVersion();
        }
        return this.lastAffChangedTopVer;
    }

    public void lastAffinityChangedTopologyVersion(AffinityTopologyVersion topVer) {
        this.lastAffChangedTopVer = topVer;
    }

    public abstract boolean addDeploymentInfo();

    protected final void prepareObject(@Nullable Object o, GridCacheContext ctx) throws IgniteCheckedException {
        this.prepareObject(o, ctx.shared());
    }

    protected final void prepareObject(@Nullable Object o, GridCacheSharedContext ctx) throws IgniteCheckedException {
        assert (this.addDepInfo || this.forceAddDepInfo);
        if (!this.skipPrepare && o != null) {
            GridDeploymentInfoBean d = ctx.deploy().globalDeploymentInfo();
            if (d != null) {
                this.prepare(d);
                this.skipPrepare = true;
            } else {
                Class<?> cls = U.detectClass(o);
                ctx.deploy().registerClass(cls);
                ClassLoader ldr = U.detectClassLoader(cls);
                if (ldr instanceof GridDeploymentInfo) {
                    this.prepare((GridDeploymentInfo)((Object)ldr));
                }
            }
        }
    }

    public final void prepare(GridDeploymentInfo depInfo) {
        if (depInfo != this.depInfo) {
            if (this.depInfo != null && depInfo instanceof GridDeployment && ((GridDeployment)depInfo).local()) {
                return;
            }
            this.depInfo = depInfo instanceof GridDeploymentInfoBean ? (GridDeploymentInfoBean)depInfo : new GridDeploymentInfoBean(depInfo);
        }
    }

    public GridDeploymentInfo deployInfo() {
        return this.depInfo;
    }

    public void prepareMarshal(GridCacheSharedContext<?, ?> ctx) throws IgniteCheckedException {
    }

    public void finishUnmarshal(GridCacheSharedContext<?, ?> ctx, ClassLoader ldr) throws IgniteCheckedException {
    }

    protected final void marshalInfo(GridCacheEntryInfo info, GridCacheSharedContext ctx, CacheObjectContext cacheObjCtx) throws IgniteCheckedException {
        assert (ctx != null);
        if (info != null) {
            info.marshal(cacheObjCtx);
            if (this.addDepInfo) {
                CacheObject val;
                if (info.key() != null) {
                    this.prepareObject(info.key().value(cacheObjCtx, false), ctx);
                }
                if ((val = info.value()) != null) {
                    val.finishUnmarshal(cacheObjCtx, ctx.deploy().globalLoader());
                    this.prepareObject(val.value(cacheObjCtx, false), ctx);
                }
            }
        }
    }

    protected final void unmarshalInfo(GridCacheEntryInfo info, GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (ldr != null);
        assert (ctx != null);
        if (info != null) {
            info.unmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    protected final void marshalInfos(Iterable<? extends GridCacheEntryInfo> infos, GridCacheSharedContext ctx, CacheObjectContext cacheObjCtx) throws IgniteCheckedException {
        assert (ctx != null);
        if (infos != null) {
            for (GridCacheEntryInfo gridCacheEntryInfo : infos) {
                this.marshalInfo(gridCacheEntryInfo, ctx, cacheObjCtx);
            }
        }
    }

    protected final void unmarshalInfos(Iterable<? extends GridCacheEntryInfo> infos, GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (ldr != null);
        assert (ctx != null);
        if (infos != null) {
            for (GridCacheEntryInfo gridCacheEntryInfo : infos) {
                this.unmarshalInfo(gridCacheEntryInfo, ctx, ldr);
            }
        }
    }

    protected final void marshalTx(Iterable<IgniteTxEntry> txEntries, GridCacheSharedContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        if (txEntries != null) {
            boolean transferExpiry = this.transferExpiryPolicy();
            boolean p2pEnabled = ctx.deploymentEnabled();
            for (IgniteTxEntry e : txEntries) {
                e.marshal(ctx, transferExpiry);
                GridCacheContext<?, ?> cctx = e.context();
                if (this.addDepInfo) {
                    if (e.key() != null) {
                        this.prepareObject(e.key().value(cctx.cacheObjectContext(), false), ctx);
                    }
                    if (e.value() != null) {
                        this.prepareObject(e.value().value(cctx.cacheObjectContext(), false), ctx);
                    }
                    if (e.entryProcessors() == null) continue;
                    for (T2<EntryProcessor<Object, Object, Object>, Object[]> entProc : e.entryProcessors()) {
                        this.prepareObject(entProc.get1(), ctx);
                    }
                    continue;
                }
                if (!p2pEnabled || e.entryProcessors() == null) continue;
                if (!this.forceAddDepInfo) {
                    this.forceAddDepInfo = true;
                }
                for (T2<EntryProcessor<Object, Object, Object>, Object[]> entProc : e.entryProcessors()) {
                    this.prepareObject(entProc.get1(), ctx);
                }
            }
        }
    }

    protected boolean transferExpiryPolicy() {
        return false;
    }

    protected final void unmarshalTx(Iterable<IgniteTxEntry> txEntries, GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (ldr != null);
        assert (ctx != null);
        if (txEntries != null) {
            for (IgniteTxEntry e : txEntries) {
                e.prepareUnmarshal(ctx, this.topologyVersion(), false);
                e.unmarshal(ctx, false, ldr);
            }
        }
    }

    @Nullable
    protected final byte[][] marshalInvokeArguments(@Nullable Object[] args, GridCacheContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        if (args == null || args.length == 0) {
            return null;
        }
        byte[][] argsBytes = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (this.addDepInfo) {
                this.prepareObject(arg, ctx.shared());
            }
            argsBytes[i] = arg == null ? null : CU.marshal(ctx, arg);
        }
        return argsBytes;
    }

    @Nullable
    protected final Object[] unmarshalInvokeArguments(@Nullable byte[][] byteCol, GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (ldr != null);
        assert (ctx != null);
        if (byteCol == null) {
            return null;
        }
        Object[] args = new Object[byteCol.length];
        Marshaller marsh = ctx.marshaller();
        for (int i = 0; i < byteCol.length; ++i) {
            args[i] = byteCol[i] == null ? null : U.unmarshal(marsh, byteCol[i], U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        return args;
    }

    @Nullable
    protected List<byte[]> marshalCollection(@Nullable Collection<?> col, GridCacheContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        if (col == null) {
            return null;
        }
        ArrayList<byte[]> byteCol = new ArrayList<byte[]>(col.size());
        for (Object o : col) {
            if (this.addDepInfo) {
                this.prepareObject(o, ctx.shared());
            }
            byteCol.add(o == null ? null : CU.marshal(ctx, o));
        }
        return byteCol;
    }

    public final void prepareMarshalCacheObjects(@Nullable List<? extends CacheObject> col, GridCacheContext ctx) throws IgniteCheckedException {
        if (col == null) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            this.prepareMarshalCacheObject(col.get(i), ctx);
        }
    }

    protected final void prepareMarshalCacheObject(CacheObject obj, GridCacheContext ctx) throws IgniteCheckedException {
        if (obj != null) {
            obj.prepareMarshal(ctx.cacheObjectContext());
            if (this.addDepInfo) {
                this.prepareObject(obj.value(ctx.cacheObjectContext(), false), ctx.shared());
            }
        }
    }

    protected final void prepareMarshalCacheObjects(@Nullable Collection<? extends CacheObject> col, GridCacheContext ctx) throws IgniteCheckedException {
        if (col == null) {
            return;
        }
        for (CacheObject cacheObject : col) {
            if (cacheObject == null) continue;
            cacheObject.prepareMarshal(ctx.cacheObjectContext());
            if (!this.addDepInfo) continue;
            this.prepareObject(cacheObject.value(ctx.cacheObjectContext(), false), ctx.shared());
        }
    }

    public final void finishUnmarshalCacheObjects(@Nullable List<? extends CacheObject> col, GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (col == null) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            CacheObject obj = col.get(i);
            if (obj == null) continue;
            obj.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    protected final void finishUnmarshalCacheObjects(@Nullable Collection<? extends CacheObject> col, GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (col == null) {
            return;
        }
        for (CacheObject cacheObject : col) {
            if (cacheObject == null) continue;
            cacheObject.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    @Override
    public void onAckReceived() {
    }

    @Nullable
    protected <T> List<T> unmarshalCollection(@Nullable Collection<byte[]> byteCol, GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (ldr != null);
        assert (ctx != null);
        if (byteCol == null) {
            return null;
        }
        ArrayList<Object> col = new ArrayList<Object>(byteCol.size());
        Marshaller marsh = ctx.marshaller();
        for (byte[] bytes : byteCol) {
            col.add(bytes == null ? null : (Object)U.unmarshal(marsh, bytes, U.resolveClassLoader(ldr, ctx.gridConfig())));
        }
        return col;
    }

    public IgniteLogger messageLogger(GridCacheSharedContext<?, ?> ctx) {
        return ctx.messageLogger();
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("depInfo", this.depInfo)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeAffinityTopologyVersion("lastAffChangedTopVer", this.lastAffChangedTopVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("msgId", this.msgId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.depInfo = (GridDeploymentInfoBean)reader.readMessage("depInfo");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.lastAffChangedTopVer = reader.readAffinityTopologyVersion("lastAffChangedTopVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msgId = reader.readLong("msgId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheMessage.class);
    }

    protected final void appendFlag(StringBuilder str, String name) {
        if (str.length() > 0) {
            str.append('|');
        }
        str.append(name);
    }

    public String toString() {
        return S.toString(GridCacheMessage.class, this);
    }
}

