/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CacheGroupAffinityMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionCountersMap2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionHistorySuppliersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionsToReloadMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsFullMessage
extends GridDhtPartitionsAbstractMessage {
    private static final byte REBALANCED_FLAG_MASK = 1;
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, GridDhtPartitionFullMap> parts;
    @GridDirectMap(keyType=Integer.class, valueType=Integer.class)
    private Map<Integer, Integer> dupPartsData;
    private byte[] partsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionCountersMap partCntrs;
    private byte[] partCntrsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionCountersMap2 partCntrs2;
    private byte[] partCntrsBytes2;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionHistorySuppliersMap partHistSuppliers;
    private byte[] partHistSuppliersBytes;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionsToReloadMap partsToReload;
    private byte[] partsToReloadBytes;
    private byte[] partsSizesBytes;
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    @GridDirectTransient
    private Map<UUID, Exception> errs;
    private byte[] errsBytes;
    private AffinityTopologyVersion resTopVer;
    @GridDirectMap(keyType=Integer.class, valueType=CacheGroupAffinityMessage.class)
    private Map<Integer, CacheGroupAffinityMessage> joinedNodeAff;
    @GridDirectMap(keyType=Integer.class, valueType=CacheGroupAffinityMessage.class)
    private Map<Integer, CacheGroupAffinityMessage> idealAffDiff;
    private byte flags;
    @GridDirectMap(keyType=Integer.class, valueType=int[].class)
    @GridToStringExclude
    private Map<Integer, int[]> lostParts;

    public GridDhtPartitionsFullMessage() {
    }

    public GridDhtPartitionsFullMessage(@Nullable GridDhtPartitionExchangeId id, @Nullable GridCacheVersion lastVer, @NotNull AffinityTopologyVersion topVer, @Nullable IgniteDhtPartitionHistorySuppliersMap partHistSuppliers, @Nullable IgniteDhtPartitionsToReloadMap partsToReload) {
        super(id, lastVer);
        assert (id == null || topVer.equals(id.topologyVersion()));
        this.topVer = topVer;
        this.partHistSuppliers = partHistSuppliers;
        this.partsToReload = partsToReload;
    }

    @Override
    void copyStateTo(GridDhtPartitionsAbstractMessage msg) {
        super.copyStateTo(msg);
        GridDhtPartitionsFullMessage cp = (GridDhtPartitionsFullMessage)msg;
        if (this.parts != null) {
            cp.parts = new HashMap<Integer, GridDhtPartitionFullMap>(this.parts.size());
            for (Map.Entry<Integer, GridDhtPartitionFullMap> e : this.parts.entrySet()) {
                GridDhtPartitionFullMap val = e.getValue();
                cp.parts.put(e.getKey(), new GridDhtPartitionFullMap(val.nodeId(), val.nodeOrder(), val.updateSequence(), val, false));
            }
        } else {
            cp.parts = null;
        }
        cp.dupPartsData = this.dupPartsData;
        cp.partsBytes = this.partsBytes;
        cp.partCntrs = this.partCntrs;
        cp.partCntrsBytes = this.partCntrsBytes;
        cp.partCntrs2 = this.partCntrs2;
        cp.partCntrsBytes2 = this.partCntrsBytes2;
        cp.partHistSuppliers = this.partHistSuppliers;
        cp.partHistSuppliersBytes = this.partHistSuppliersBytes;
        cp.partsToReload = this.partsToReload;
        cp.partsToReloadBytes = this.partsToReloadBytes;
        cp.partsSizesBytes = this.partsSizesBytes;
        cp.topVer = this.topVer;
        cp.errs = this.errs;
        cp.errsBytes = this.errsBytes;
        cp.resTopVer = this.resTopVer;
        cp.joinedNodeAff = this.joinedNodeAff;
        cp.idealAffDiff = this.idealAffDiff;
        cp.flags = this.flags;
        cp.lostParts = this.lostParts;
    }

    public GridDhtPartitionsFullMessage copy() {
        GridDhtPartitionsFullMessage cp = new GridDhtPartitionsFullMessage();
        this.copyStateTo(cp);
        return cp;
    }

    public void resultTopologyVersion(AffinityTopologyVersion resTopVer) {
        this.resTopVer = resTopVer;
    }

    public AffinityTopologyVersion resultTopologyVersion() {
        return this.resTopVer;
    }

    @Nullable
    public Map<Integer, CacheGroupAffinityMessage> joinedNodeAffinity() {
        return this.joinedNodeAff;
    }

    GridDhtPartitionsFullMessage joinedNodeAffinity(Map<Integer, CacheGroupAffinityMessage> joinedNodeAff) {
        this.joinedNodeAff = joinedNodeAff;
        return this;
    }

    @Nullable
    public Map<Integer, CacheGroupAffinityMessage> idealAffinityDiff() {
        return this.idealAffDiff;
    }

    void idealAffinityDiff(Map<Integer, CacheGroupAffinityMessage> idealAffDiff) {
        this.idealAffDiff = idealAffDiff;
    }

    @Override
    public int handlerId() {
        return 0;
    }

    public Map<Integer, GridDhtPartitionFullMap> partitions() {
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        return this.parts;
    }

    public boolean containsGroup(int grpId) {
        return this.parts != null && this.parts.containsKey(grpId);
    }

    public void addFullPartitionsMap(int grpId, GridDhtPartitionFullMap fullMap, @Nullable Integer dupDataCache) {
        assert (fullMap != null);
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        if (!this.parts.containsKey(grpId)) {
            this.parts.put(grpId, fullMap);
            if (dupDataCache != null) {
                assert (this.compressed());
                assert (this.parts.containsKey(dupDataCache));
                if (this.dupPartsData == null) {
                    this.dupPartsData = new HashMap<Integer, Integer>();
                }
                this.dupPartsData.put(grpId, dupDataCache);
            }
        }
    }

    public void addPartitionUpdateCounters(int grpId, Map<Integer, T2<Long, Long>> cntrMap) {
        if (this.partCntrs == null) {
            this.partCntrs = new IgniteDhtPartitionCountersMap();
        }
        this.partCntrs.putIfAbsent(grpId, cntrMap);
    }

    public void addPartitionUpdateCounters(int grpId, CachePartitionFullCountersMap cntrMap) {
        if (this.partCntrs2 == null) {
            this.partCntrs2 = new IgniteDhtPartitionCountersMap2();
        }
        this.partCntrs2.putIfAbsent(grpId, cntrMap);
    }

    public void addLostPartitions(int grpId, Collection<Integer> lostParts) {
        if (lostParts.isEmpty()) {
            return;
        }
        if (this.lostParts == null) {
            this.lostParts = new HashMap<Integer, int[]>();
        }
        this.lostParts.put(grpId, lostParts.stream().mapToInt(v -> v).toArray());
    }

    @Nullable
    public Set<Integer> lostPartitions(int grpId) {
        if (this.lostParts == null) {
            return null;
        }
        int[] parts = this.lostParts.get(grpId);
        if (parts == null) {
            return Collections.emptySet();
        }
        return IntStream.of(parts).boxed().collect(Collectors.toSet());
    }

    public CachePartitionFullCountersMap partitionUpdateCounters(int grpId, int partsCnt) {
        if (this.partCntrs2 != null) {
            return this.partCntrs2.get(grpId);
        }
        if (this.partCntrs == null) {
            return null;
        }
        Map<Integer, T2<Long, Long>> map = this.partCntrs.get(grpId);
        return map != null ? CachePartitionFullCountersMap.fromCountersMap(map, partsCnt) : null;
    }

    public IgniteDhtPartitionHistorySuppliersMap partitionHistorySuppliers() {
        if (this.partHistSuppliers == null) {
            return IgniteDhtPartitionHistorySuppliersMap.empty();
        }
        return this.partHistSuppliers;
    }

    public Set<Integer> partsToReload(UUID nodeId, int grpId) {
        if (this.partsToReload == null) {
            return Collections.emptySet();
        }
        return this.partsToReload.get(nodeId, grpId);
    }

    public void partitionSizes(GridCacheSharedContext ctx, Map<Integer, Map<Integer, Long>> partsSizes) {
        try {
            byte[] marshalled = U.marshal(ctx, partsSizes);
            if (this.compressed()) {
                marshalled = U.zip(marshalled, ctx.gridConfig().getNetworkCompressionLevel());
            }
            this.partsSizesBytes = marshalled;
        }
        catch (IgniteCheckedException ex) {
            throw new IgniteException(ex);
        }
    }

    public Map<Integer, Map<Integer, Long>> partitionSizes(GridCacheSharedContext ctx) {
        if (this.partsSizesBytes == null) {
            return Collections.emptyMap();
        }
        try {
            return this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partsSizesBytes, ctx.deploy().globalLoader()) : (Map)U.unmarshal(ctx, this.partsSizesBytes, ctx.deploy().globalLoader());
        }
        catch (IgniteCheckedException ex) {
            throw new IgniteException(ex);
        }
    }

    @Nullable
    Map<UUID, Exception> getErrorsMap() {
        return this.errs;
    }

    void setErrorsMap(Map<UUID, Exception> errs) {
        this.errs = new HashMap<UUID, Exception>(errs);
    }

    public boolean rebalanced() {
        return (this.flags & 1) != 0;
    }

    public void rebalanced(boolean rebalanced) {
        this.flags = rebalanced ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public void prepareMarshal(final GridCacheSharedContext ctx) throws IgniteCheckedException {
        boolean marshal;
        super.prepareMarshal(ctx);
        boolean bl = marshal = !F.isEmpty(this.parts) && this.partsBytes == null || this.partCntrs != null && !this.partCntrs.empty() && this.partCntrsBytes == null || this.partCntrs2 != null && !this.partCntrs2.empty() && this.partCntrsBytes2 == null || this.partHistSuppliers != null && this.partHistSuppliersBytes == null || this.partsToReload != null && this.partsToReloadBytes == null || !F.isEmpty(this.errs) && this.errsBytes == null;
        if (marshal) {
            int parallelismLvl = U.availableThreadCount(ctx.kernalContext(), (byte)2, 2);
            ArrayList<Object> objectsToMarshall = new ArrayList<Object>();
            if (!F.isEmpty(this.parts) && this.partsBytes == null) {
                objectsToMarshall.add(this.parts);
            }
            if (this.partCntrs != null && !this.partCntrs.empty() && this.partCntrsBytes == null) {
                objectsToMarshall.add(this.partCntrs);
            }
            if (this.partCntrs2 != null && !this.partCntrs2.empty() && this.partCntrsBytes2 == null) {
                objectsToMarshall.add(this.partCntrs2);
            }
            if (this.partHistSuppliers != null && this.partHistSuppliersBytes == null) {
                objectsToMarshall.add(this.partHistSuppliers);
            }
            if (this.partsToReload != null && this.partsToReloadBytes == null) {
                objectsToMarshall.add(this.partsToReload);
            }
            if (!F.isEmpty(this.errs) && this.errsBytes == null) {
                objectsToMarshall.add(this.errs);
            }
            Collection<byte[]> marshalled = U.doInParallel(parallelismLvl, ctx.kernalContext().pools().getSystemExecutorService(), objectsToMarshall, new IgniteThrowableFunction<Object, byte[]>(){

                @Override
                public byte[] apply(Object payload) throws IgniteCheckedException {
                    byte[] marshalled = U.marshal(ctx, payload);
                    if (GridDhtPartitionsFullMessage.this.compressed()) {
                        marshalled = U.zip(marshalled, ctx.gridConfig().getNetworkCompressionLevel());
                    }
                    return marshalled;
                }
            });
            Iterator<byte[]> iter = marshalled.iterator();
            if (!F.isEmpty(this.parts) && this.partsBytes == null) {
                this.partsBytes = iter.next();
            }
            if (this.partCntrs != null && !this.partCntrs.empty() && this.partCntrsBytes == null) {
                this.partCntrsBytes = iter.next();
            }
            if (this.partCntrs2 != null && !this.partCntrs2.empty() && this.partCntrsBytes2 == null) {
                this.partCntrsBytes2 = iter.next();
            }
            if (this.partHistSuppliers != null && this.partHistSuppliersBytes == null) {
                this.partHistSuppliersBytes = iter.next();
            }
            if (this.partsToReload != null && this.partsToReloadBytes == null) {
                this.partsToReloadBytes = iter.next();
            }
            if (!F.isEmpty(this.errs) && this.errsBytes == null) {
                this.errsBytes = iter.next();
            }
        }
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public void finishUnmarshal(final GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        final ClassLoader clsLdr = U.resolveClassLoader(ldr, ctx.gridConfig());
        ArrayList<byte[]> objectsToUnmarshall = new ArrayList<byte[]>();
        int parallelismLvl = U.availableThreadCount(ctx.kernalContext(), (byte)2, 2);
        if (this.partsBytes != null && this.parts == null) {
            objectsToUnmarshall.add(this.partsBytes);
        }
        if (this.partCntrsBytes != null && this.partCntrs == null) {
            objectsToUnmarshall.add(this.partCntrsBytes);
        }
        if (this.partCntrsBytes2 != null && this.partCntrs2 == null) {
            objectsToUnmarshall.add(this.partCntrsBytes2);
        }
        if (this.partHistSuppliersBytes != null && this.partHistSuppliers == null) {
            objectsToUnmarshall.add(this.partHistSuppliersBytes);
        }
        if (this.partsToReloadBytes != null && this.partsToReload == null) {
            objectsToUnmarshall.add(this.partsToReloadBytes);
        }
        if (this.errsBytes != null && this.errs == null) {
            objectsToUnmarshall.add(this.errsBytes);
        }
        Collection<Object> unmarshalled = U.doInParallel(parallelismLvl, ctx.kernalContext().pools().getSystemExecutorService(), objectsToUnmarshall, new IgniteThrowableFunction<byte[], Object>(){

            @Override
            public Object apply(byte[] binary) throws IgniteCheckedException {
                return GridDhtPartitionsFullMessage.this.compressed() ? U.unmarshalZip(ctx.marshaller(), binary, clsLdr) : U.unmarshal(ctx, binary, clsLdr);
            }
        });
        Iterator<Object> iter = unmarshalled.iterator();
        if (this.partsBytes != null && this.parts == null) {
            this.parts = (Map)iter.next();
            if (this.dupPartsData != null) {
                assert (this.parts != null);
                for (Map.Entry<Integer, Integer> e : this.dupPartsData.entrySet()) {
                    GridDhtPartitionFullMap map1 = this.parts.get(e.getKey());
                    GridDhtPartitionFullMap map2 = this.parts.get(e.getValue());
                    assert (map1 != null) : e.getKey();
                    assert (map2 != null) : e.getValue();
                    assert (map1.size() == map2.size());
                    for (Map.Entry e0 : map2.entrySet()) {
                        GridDhtPartitionMap partMap1 = (GridDhtPartitionMap)map1.get(e0.getKey());
                        assert (partMap1 != null && partMap1.map().isEmpty()) : partMap1;
                        assert (!partMap1.hasMovingPartitions()) : partMap1;
                        GridDhtPartitionMap partMap2 = (GridDhtPartitionMap)e0.getValue();
                        assert (partMap2 != null);
                        for (Map.Entry<Integer, GridDhtPartitionState> stateEntry : partMap2.entrySet()) {
                            partMap1.put(stateEntry.getKey(), stateEntry.getValue());
                        }
                    }
                }
            }
        }
        if (this.partCntrsBytes != null && this.partCntrs == null) {
            this.partCntrs = (IgniteDhtPartitionCountersMap)iter.next();
        }
        if (this.partCntrsBytes2 != null && this.partCntrs2 == null) {
            this.partCntrs2 = (IgniteDhtPartitionCountersMap2)iter.next();
        }
        if (this.partHistSuppliersBytes != null && this.partHistSuppliers == null) {
            this.partHistSuppliers = (IgniteDhtPartitionHistorySuppliersMap)iter.next();
        }
        if (this.partsToReloadBytes != null && this.partsToReload == null) {
            this.partsToReload = (IgniteDhtPartitionsToReloadMap)iter.next();
        }
        if (this.errsBytes != null && this.errs == null) {
            this.errs = (Map)iter.next();
        }
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        if (this.partCntrs == null) {
            this.partCntrs = new IgniteDhtPartitionCountersMap();
        }
        if (this.partCntrs2 == null) {
            this.partCntrs2 = new IgniteDhtPartitionCountersMap2();
        }
        if (this.partHistSuppliers == null) {
            this.partHistSuppliers = new IgniteDhtPartitionHistorySuppliersMap();
        }
        if (this.partsToReload == null) {
            this.partsToReload = new IgniteDhtPartitionsToReloadMap();
        }
        if (this.errs == null) {
            this.errs = new HashMap<UUID, Exception>();
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 6: {
                if (!writer.writeMap("dupPartsData", this.dupPartsData, MessageCollectionItemType.INT, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeByteArray("errsBytes", this.errsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMap("idealAffDiff", this.idealAffDiff, MessageCollectionItemType.INT, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMap("joinedNodeAff", this.joinedNodeAff, MessageCollectionItemType.INT, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMap("lostParts", this.lostParts, MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeByteArray("partCntrsBytes", this.partCntrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeByteArray("partCntrsBytes2", this.partCntrsBytes2)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeByteArray("partHistSuppliersBytes", this.partHistSuppliersBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeByteArray("partsBytes", this.partsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeByteArray("partsSizesBytes", this.partsSizesBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeByteArray("partsToReloadBytes", this.partsToReloadBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeAffinityTopologyVersion("resTopVer", this.resTopVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 6: {
                this.dupPartsData = reader.readMap("dupPartsData", MessageCollectionItemType.INT, MessageCollectionItemType.INT, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.errsBytes = reader.readByteArray("errsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.idealAffDiff = reader.readMap("idealAffDiff", MessageCollectionItemType.INT, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.joinedNodeAff = reader.readMap("joinedNodeAff", MessageCollectionItemType.INT, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.lostParts = reader.readMap("lostParts", MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.partCntrsBytes = reader.readByteArray("partCntrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.partCntrsBytes2 = reader.readByteArray("partCntrsBytes2");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.partHistSuppliersBytes = reader.readByteArray("partHistSuppliersBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.partsBytes = reader.readByteArray("partsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.partsSizesBytes = reader.readByteArray("partsSizesBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.partsToReloadBytes = reader.readByteArray("partsToReloadBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.resTopVer = reader.readAffinityTopologyVersion("resTopVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionsFullMessage.class);
    }

    @Override
    public short directType() {
        return 46;
    }

    @Override
    public byte fieldsCount() {
        return 20;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionsFullMessage.class, this, "partCnt", (Object)(this.parts != null ? this.parts.size() : 0), "super", (Object)super.toString());
    }

    public void merge(GridDhtPartitionsFullMessage other, GridDiscoveryManager discovery) {
        assert (other.exchangeId() == null && this.exchangeId() == null) : "Both current and merge full message must have exchangeId == null" + other.exchangeId() + "," + this.exchangeId();
        for (Map.Entry<Integer, GridDhtPartitionFullMap> grpAndMap : other.partitions().entrySet()) {
            int grpId = grpAndMap.getKey();
            GridDhtPartitionFullMap updMap = grpAndMap.getValue();
            GridDhtPartitionFullMap currMap = this.partitions().get(grpId);
            if (currMap == null) {
                this.partitions().put(grpId, updMap);
                continue;
            }
            ClusterNode curMapSentBy = discovery.node(currMap.nodeId());
            ClusterNode newMapSentBy = discovery.node(updMap.nodeId());
            if (newMapSentBy == null || curMapSentBy != null && newMapSentBy.order() <= curMapSentBy.order() && updMap.compareTo(currMap) < 0) continue;
            this.partitions().put(grpId, updMap);
        }
    }

    public void cleanUp() {
        this.partsBytes = null;
        this.partCntrs2 = null;
        this.partCntrsBytes = null;
        this.partCntrsBytes2 = null;
        this.partHistSuppliersBytes = null;
        this.partsToReloadBytes = null;
        this.partsSizesBytes = null;
        this.errsBytes = null;
    }
}

