/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheCompressionManager
extends GridCacheManagerAdapter {
    private DiskPageCompression diskPageCompression;
    private int diskPageCompressLevel;
    private CompressionProcessor compressProc;

    @Override
    protected void start0() throws IgniteCheckedException {
        CacheConfiguration cfg = this.cctx.config();
        if (this.cctx.kernalContext().clientNode() || !CU.isPersistentCache(cfg, this.cctx.gridConfig().getDataStorageConfiguration())) {
            this.diskPageCompression = DiskPageCompression.DISABLED;
            return;
        }
        this.compressProc = this.cctx.kernalContext().compress();
        DiskPageCompression diskPageCompression = this.diskPageCompression = this.cctx.kernalContext().config().isClientMode() != false ? null : cfg.getDiskPageCompression();
        if (this.diskPageCompression != DiskPageCompression.DISABLED) {
            if (!this.cctx.dataRegion().config().isPersistenceEnabled()) {
                throw new IgniteCheckedException("Disk page compression makes sense only with enabled persistence.");
            }
            Integer lvl = cfg.getDiskPageCompressionLevel();
            this.diskPageCompressLevel = lvl != null ? CompressionProcessor.checkCompressionLevelBounds(lvl, this.diskPageCompression) : CompressionProcessor.getDefaultCompressionLevel(this.diskPageCompression);
            DataStorageConfiguration dsCfg = this.cctx.kernalContext().config().getDataStorageConfiguration();
            File dbPath = this.cctx.kernalContext().pdsFolderResolver().resolveFolders().persistentStoreRootPath();
            assert (dbPath != null);
            this.compressProc.checkPageCompressionSupported(dbPath.toPath(), dsCfg.getPageSize());
            if (this.log.isInfoEnabled()) {
                this.log.info("Disk page compression is enabled [cache=" + this.cctx.name() + ", compression=" + (Object)((Object)this.diskPageCompression) + ", level=" + this.diskPageCompressLevel + "]");
            }
        }
    }

    public ByteBuffer compressPage(ByteBuffer page, PageStore store) throws IgniteCheckedException {
        if (this.diskPageCompression == DiskPageCompression.DISABLED) {
            return page;
        }
        int blockSize = store.getBlockSize();
        if (blockSize <= 0) {
            throw new IgniteCheckedException("Failed to detect storage block size on " + U.osString());
        }
        return this.compressProc.compressPage(page, store.getPageSize(), blockSize, this.diskPageCompression, this.diskPageCompressLevel);
    }
}

