/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheStartTaskArg;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorCacheStartTask
extends VisorMultiNodeTask<VisorCacheStartTaskArg, Map<UUID, IgniteException>, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheStartJob job(VisorCacheStartTaskArg arg) {
        return new VisorCacheStartJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<UUID, IgniteException> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap<UUID, IgniteException> map = new HashMap<UUID, IgniteException>();
        for (ComputeJobResult res : results) {
            if (res.getException() == null) continue;
            map.put(res.getNode().id(), res.getException());
        }
        return map;
    }

    private static class VisorCacheStartJob
    extends VisorJob<VisorCacheStartTaskArg, Void> {
        private static final long serialVersionUID = 0L;

        private VisorCacheStartJob(VisorCacheStartTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Void run(VisorCacheStartTaskArg arg) throws IgniteException {
            String cfg = arg.getConfiguration();
            assert (!F.isEmpty(cfg));
            try (ByteArrayInputStream bais = new ByteArrayInputStream(cfg.getBytes());){
                if (arg.isNear()) {
                    NearCacheConfiguration nearCfg = (NearCacheConfiguration)Ignition.loadSpringBean(bais, "nearCacheConfiguration");
                    this.ignite.getOrCreateNearCache(VisorTaskUtils.unescapeName(arg.getName()), nearCfg);
                } else {
                    CacheConfiguration cacheCfg = (CacheConfiguration)((Object)Ignition.loadSpringBean(bais, "cacheConfiguration"));
                    this.ignite.getOrCreateCache(cacheCfg);
                }
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorCacheStartJob.class, this);
        }
    }
}

