/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceClosure;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceJobResult;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTaskArg;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorFindAndDeleteGarbageInPersistenceTask
extends VisorMultiNodeTask<VisorFindAndDeleteGarbageInPersistenceTaskArg, VisorFindAndDeleteGarbageInPersistenceTaskResult, VisorFindAndDeleteGarbageInPersistenceJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected VisorFindAndDeleteGarbageInPersistenceTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, Exception> exceptions = new HashMap<UUID, Exception>();
        HashMap<UUID, VisorFindAndDeleteGarbageInPersistenceJobResult> jobResults = new HashMap<UUID, VisorFindAndDeleteGarbageInPersistenceJobResult>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            jobResults.put(res.getNode().id(), (VisorFindAndDeleteGarbageInPersistenceJobResult)res.getData());
        }
        return new VisorFindAndDeleteGarbageInPersistenceTaskResult(jobResults, exceptions);
    }

    @Override
    protected VisorJob<VisorFindAndDeleteGarbageInPersistenceTaskArg, VisorFindAndDeleteGarbageInPersistenceJobResult> job(VisorFindAndDeleteGarbageInPersistenceTaskArg arg) {
        return new FindAndDeleteGarbageInPersistenceJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorFindAndDeleteGarbageInPersistenceTaskArg> arg) {
        Collection<ClusterNode> srvNodes = this.ignite.cluster().forServers().nodes();
        ArrayList<UUID> ret = new ArrayList<UUID>(srvNodes.size());
        Set<UUID> nodeIds = arg.getArgument().getNodes();
        if (nodeIds == null) {
            for (ClusterNode node : srvNodes) {
                ret.add(node.id());
            }
        } else {
            for (ClusterNode node : srvNodes) {
                if (!nodeIds.contains(node.id())) continue;
                ret.add(node.id());
            }
        }
        return ret;
    }

    private static class FindAndDeleteGarbageInPersistenceJob
    extends VisorJob<VisorFindAndDeleteGarbageInPersistenceTaskArg, VisorFindAndDeleteGarbageInPersistenceJobResult> {
        private static final long serialVersionUID = 0L;

        protected FindAndDeleteGarbageInPersistenceJob(@Nullable VisorFindAndDeleteGarbageInPersistenceTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorFindAndDeleteGarbageInPersistenceJobResult run(@Nullable VisorFindAndDeleteGarbageInPersistenceTaskArg arg) throws IgniteException {
            try {
                VisorFindAndDeleteGarbageInPersistenceClosure closure = new VisorFindAndDeleteGarbageInPersistenceClosure(arg.getGrpNames(), arg.deleteFoundGarbage());
                this.ignite.context().resource().injectGeneric(closure);
                return closure.call();
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(FindAndDeleteGarbageInPersistenceJob.class, this);
        }
    }
}

